/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class JpaDiscriminatorColumn
implements XMLSerializable {
    public static final int DEFAULT_LENGTH = 31;
    protected String name;
    protected DiscriminatorType discriminatorType = DiscriminatorType.STRING;
    protected String columnDefinition;
    protected int length;

    public JpaDiscriminatorColumn() {
    }

    public JpaDiscriminatorColumn(DiscriminatorColumn annotation) {
        this.name = annotation.name();
        this.discriminatorType = annotation.discriminatorType();
        this.columnDefinition = annotation.columnDefinition();
        this.length = annotation.length();
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<discriminator-column");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        if (this.discriminatorType != null && this.discriminatorType != DiscriminatorType.STRING) {
            encoder.print(" discriminator-type=\"" + this.discriminatorType.name() + "\"");
        }
        if (this.columnDefinition != null) {
            encoder.print(" column-definition=\"" + this.columnDefinition + "\"");
        }
        if (this.length > 0 && this.length != 31) {
            encoder.print(" length=\"" + this.length + "\"");
        }
        encoder.println("/>");
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    public void setDiscriminatorType(DiscriminatorType discriminatrorType) {
        this.discriminatorType = discriminatrorType;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

