/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.AssociationOverride;
import org.apache.cayenne.jpa.map.JpaJoinColumn;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaAssociationOverride
implements XMLSerializable {
    protected String name;
    protected Collection<JpaJoinColumn> joinColumns;

    public JpaAssociationOverride() {
    }

    public JpaAssociationOverride(AssociationOverride annotation) {
        this.name = annotation.name();
        if (annotation.joinColumns() != null) {
            for (int i = 0; i < annotation.joinColumns().length; ++i) {
                this.getJoinColumns().add(new JpaJoinColumn(annotation.joinColumns()[i]));
            }
        }
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<association-override");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        encoder.println('>');
        encoder.indent(1);
        for (JpaJoinColumn c : this.getJoinColumns()) {
            c.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</association-override>");
    }

    public Collection<JpaJoinColumn> getJoinColumns() {
        if (this.joinColumns == null) {
            this.joinColumns = new ArrayList<JpaJoinColumn>();
        }
        return this.joinColumns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

