/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.cayenne.access.types.CalendarType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.sqlite.SQLiteDateType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

class SQLiteCalendarType
implements ExtendedType {
    protected ExtendedType delegateCalendarType;
    protected ExtendedType delegateDateType;

    public SQLiteCalendarType(Class calendarClass) {
        this.delegateCalendarType = new CalendarType(calendarClass);
        this.delegateDateType = new SQLiteDateType();
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return this.delegateCalendarType.validateProperty(source, property, value, dbAttribute, validationResult);
    }

    public String getClassName() {
        return this.delegateCalendarType.getClassName();
    }

    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Date date = (Date)this.delegateDateType.materializeObject(rs, index, type);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date date = (Date)this.delegateDateType.materializeObject(rs, index, type);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        this.delegateCalendarType.setJdbcObject(statement, value, pos, type, precision);
    }
}

