/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;

class OracleProcedureAction
extends ProcedureAction {
    OracleProcedureAction(ProcedureQuery query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readProcedureOutParameters(CallableStatement statement, OperationObserver delegate) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> result = null;
        List parameters = this.getProcedure().getCallParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            ProcedureParameter parameter = (ProcedureParameter)parameters.get(i);
            if (!parameter.isOutParam()) continue;
            if (parameter.getType() == OracleAdapter.getOracleCursorType()) {
                ResultSet rs = (ResultSet)statement.getObject(i + 1);
                try {
                    RowDescriptor rsDescriptor = this.describeResultSet(rs, this.processedResultSets++);
                    this.readResultSet(rs, rsDescriptor, this.query, delegate);
                    continue;
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {}
                }
            }
            if (result == null) {
                result = new HashMap<String, Object>();
            }
            ColumnDescriptor descriptor = new ColumnDescriptor(parameter);
            ExtendedType type = this.getAdapter().getExtendedTypes().getRegisteredType(descriptor.getJavaClass());
            Object val = type.materializeObject(statement, i + 1, descriptor.getJdbcType());
            result.put(descriptor.getLabel(), val);
        }
        if (result != null && !result.isEmpty()) {
            QueryLogger.logSelectCount(1, System.currentTimeMillis() - t1);
            delegate.nextDataRows((Query)this.query, Collections.singletonList(result));
        }
    }
}

