/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapterFactoryChain;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class AutoAdapter
implements DbAdapter {
    static final DbAdapterFactory[] DEFAULT_FACTORIES = new DbAdapterFactory[]{new MySQLSniffer(), new PostgresSniffer(), new OracleSniffer(), new SQLServerSniffer(), new HSQLDBSniffer(), new DB2Sniffer(), new SybaseSniffer(), new DerbySniffer(), new OpenBaseSniffer(), new FrontBaseSniffer(), new IngresSniffer(), new SQLiteSniffer()};
    protected DbAdapterFactory adapterFactory;
    protected DataSource dataSource;
    protected PkGenerator pkGenerator;
    DbAdapter adapter;

    public static DbAdapterFactory getDefaultFactory() {
        return new DbAdapterFactoryChain(Arrays.asList(DEFAULT_FACTORIES));
    }

    public AutoAdapter(DataSource dataSource) {
        this(null, dataSource);
    }

    public AutoAdapter(DbAdapterFactory adapterFactory, DataSource dataSource) {
        if (dataSource == null) {
            throw new CayenneRuntimeException("Null dataSource");
        }
        this.adapterFactory = adapterFactory != null ? adapterFactory : this.createDefaultFactory();
        this.dataSource = dataSource;
    }

    protected DbAdapterFactory createDefaultFactory() {
        return AutoAdapter.getDefaultFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAdapter getAdapter() {
        if (this.adapter == null) {
            AutoAdapter autoAdapter = this;
            synchronized (autoAdapter) {
                if (this.adapter == null) {
                    this.adapter = this.loadAdapter();
                }
            }
        }
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAdapter loadAdapter() {
        DbAdapter adapter = null;
        try {
            Connection c = this.dataSource.getConnection();
            try {
                adapter = this.adapterFactory.createAdapter(c.getMetaData());
            }
            finally {
                try {
                    c.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Error detecting database type: " + e.getLocalizedMessage(), e);
        }
        if (adapter == null) {
            QueryLogger.log("Failed to detect database type, using default adapter");
            adapter = new JdbcAdapter();
        } else {
            QueryLogger.log("Detected and installed adapter: " + adapter.getClass().getName());
        }
        return adapter;
    }

    public String getBatchTerminator() {
        return this.getAdapter().getBatchTerminator();
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return this.getAdapter().getQualifierTranslator(queryAssembler);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return this.getAdapter().getAction(query, node);
    }

    public boolean supportsFkConstraints() {
        return this.getAdapter().supportsFkConstraints();
    }

    public boolean supportsUniqueConstraints() {
        return this.getAdapter().supportsUniqueConstraints();
    }

    public boolean supportsGeneratedKeys() {
        return this.getAdapter().supportsGeneratedKeys();
    }

    public boolean supportsBatchUpdates() {
        return this.getAdapter().supportsBatchUpdates();
    }

    public String dropTable(DbEntity entity) {
        return this.getAdapter().dropTable(entity);
    }

    public String createTable(DbEntity entity) {
        return this.getAdapter().createTable(entity);
    }

    public String createUniqueConstraint(DbEntity source, Collection columns) {
        return this.getAdapter().createUniqueConstraint(source, columns);
    }

    public String createFkConstraint(DbRelationship rel) {
        return this.getAdapter().createFkConstraint(rel);
    }

    public String[] externalTypesForJdbcType(int type) {
        return this.getAdapter().externalTypesForJdbcType(type);
    }

    public ExtendedTypeMap getExtendedTypes() {
        return this.getAdapter().getExtendedTypes();
    }

    public PkGenerator getPkGenerator() {
        return this.pkGenerator != null ? this.pkGenerator : this.getAdapter().getPkGenerator();
    }

    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        return this.getAdapter().buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        this.getAdapter().bindParameter(statement, object, pos, sqlType, precision);
    }

    public String tableTypeForTable() {
        return this.getAdapter().tableTypeForTable();
    }

    public String tableTypeForView() {
        return this.getAdapter().tableTypeForView();
    }
}

