/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;

abstract class DataChannelSyncCallbackAction
implements GraphChangeHandler {
    LifecycleCallbackRegistry callbackRegistry;
    Collection updated;
    Collection persisted;
    Collection removed;
    private Set seenIds;
    private GraphManager graphManager;

    static DataChannelSyncCallbackAction getCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 1: 
            case 2: {
                return new FlushCallbackAction(callbackRegistry, graphManager, changes);
            }
            case 3: {
                return new RollbackCallbackAction(callbackRegistry, graphManager, changes);
            }
        }
        throw new IllegalArgumentException("Unsupported sync type: " + syncType);
    }

    DataChannelSyncCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
        this.callbackRegistry = callbackRegistry;
        this.graphManager = graphManager;
        if (this.hasListeners()) {
            this.seenIds = new HashSet();
            changes.apply(this);
        }
    }

    protected abstract boolean hasListeners();

    abstract void applyPreCommit();

    abstract void applyPostCommit();

    void apply(int callbackType, Collection objects) {
        if (this.seenIds != null && objects != null) {
            this.callbackRegistry.performCallbacks(callbackType, objects);
        }
    }

    public void nodeCreated(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.persisted == null) {
                this.persisted = new ArrayList();
            }
            this.persisted.add(node);
        }
    }

    public void nodeRemoved(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.removed == null) {
                this.removed = new ArrayList();
            }
            this.removed.add(node);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.nodeUpdated(nodeId);
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.nodeUpdated(nodeId);
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.nodeUpdated(nodeId);
    }

    private void nodeUpdated(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.updated == null) {
                this.updated = new ArrayList();
            }
            this.updated.add(node);
        }
    }

    static class RollbackCallbackAction
    extends DataChannelSyncCallbackAction {
        RollbackCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
            super(callbackRegistry, graphManager, changes);
        }

        protected boolean hasListeners() {
            return !this.callbackRegistry.isEmpty(6);
        }

        void applyPreCommit() {
        }

        void applyPostCommit() {
            this.apply(6, this.updated);
            this.apply(6, this.removed);
        }
    }

    static class FlushCallbackAction
    extends DataChannelSyncCallbackAction {
        FlushCallbackAction(LifecycleCallbackRegistry callbackRegistry, GraphManager graphManager, GraphDiff changes) {
            super(callbackRegistry, graphManager, changes);
        }

        protected boolean hasListeners() {
            return !this.callbackRegistry.isEmpty(2) || !this.callbackRegistry.isEmpty(5) || !this.callbackRegistry.isEmpty(4) || !this.callbackRegistry.isEmpty(3);
        }

        void applyPreCommit() {
            this.apply(2, this.updated);
        }

        void applyPostCommit() {
            this.apply(5, this.updated);
            this.apply(4, this.removed);
            this.apply(3, this.persisted);
        }
    }
}

