/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BaseToOneProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.pojo.EnhancedPojoPropertyFaultHandler;

class EnhancedPojoToOneProperty
extends BaseToOneProperty {
    protected EnhancedPojoPropertyFaultHandler faultHandler;

    EnhancedPojoToOneProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
        this.faultHandler = new EnhancedPojoPropertyFaultHandler(owner.getObjectClass(), this.getName());
    }

    public boolean isFault(Object source) {
        return this.faultHandler.isFaultProperty(source);
    }

    public void invalidate(Object object) {
        this.faultHandler.setFaultProperty(object, true);
    }

    void resolveFault(Object object) {
        if (this.isFault(object)) {
            Object target = Fault.getToOneFault().resolveFault((Persistent)object, this.getName());
            this.writePropertyDirectly(object, null, target);
            this.faultHandler.setFaultProperty(object, false);
        }
    }

    public Object readProperty(Object object) throws PropertyException {
        this.resolveFault(object);
        return super.readProperty(object);
    }
}

