/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PersistentDescriptorFactory;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.generic.DataObjectAccessor;
import org.apache.cayenne.reflect.generic.DataObjectAttributeProperty;
import org.apache.cayenne.reflect.generic.DataObjectDescriptor;
import org.apache.cayenne.reflect.generic.DataObjectToManyProperty;
import org.apache.cayenne.reflect.generic.DataObjectToOneProperty;

public class DataObjectDescriptorFactory
extends PersistentDescriptorFactory {
    public DataObjectDescriptorFactory(ClassDescriptorMap descriptorMap) {
        super(descriptorMap);
    }

    protected ClassDescriptor getDescriptor(ObjEntity entity, Class entityClass) {
        if (!DataObject.class.isAssignableFrom(entityClass)) {
            return null;
        }
        return super.getDescriptor(entity, entityClass);
    }

    protected PersistentDescriptor createDescriptor() {
        return new DataObjectDescriptor();
    }

    protected void createAttributeProperty(PersistentDescriptor descriptor, ObjAttribute attribute) {
        descriptor.addDeclaredProperty(new DataObjectAttributeProperty(attribute));
    }

    protected void createToManyProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        descriptor.addDeclaredProperty(new DataObjectToManyProperty(relationship, targetDescriptor));
    }

    protected void createToOneProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        descriptor.addDeclaredProperty(new DataObjectToOneProperty(relationship, targetDescriptor));
    }

    protected Accessor createAccessor(PersistentDescriptor descriptor, String propertyName, Class propertyType) throws PropertyException {
        return new DataObjectAccessor(propertyName);
    }
}

