/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.DataMapValidator;
import org.apache.cayenne.project.validator.DataNodeValidator;
import org.apache.cayenne.project.validator.DbAttributeValidator;
import org.apache.cayenne.project.validator.DbEntityValidator;
import org.apache.cayenne.project.validator.DbRelationshipValidator;
import org.apache.cayenne.project.validator.DomainValidator;
import org.apache.cayenne.project.validator.ObjAttributeValidator;
import org.apache.cayenne.project.validator.ObjEntityValidator;
import org.apache.cayenne.project.validator.ObjRelationshipValidator;
import org.apache.cayenne.project.validator.ProcedureParameterValidator;
import org.apache.cayenne.project.validator.ProcedureQueryValidator;
import org.apache.cayenne.project.validator.ProcedureValidator;
import org.apache.cayenne.project.validator.SQLTemplateValidator;
import org.apache.cayenne.project.validator.SelectQueryValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

public abstract class TreeNodeValidator {
    protected static final DomainValidator domainValidator = new DomainValidator();
    protected static final DataNodeValidator nodeValidator = new DataNodeValidator();
    protected static final DataMapValidator mapValidator = new DataMapValidator();
    protected static final ObjEntityValidator objEntityValidator = new ObjEntityValidator();
    protected static final ObjAttributeValidator objAttrValidator = new ObjAttributeValidator();
    protected static final ObjRelationshipValidator objRelValidator = new ObjRelationshipValidator();
    protected static final DbEntityValidator dbEntityValidator = new DbEntityValidator();
    protected static final DbAttributeValidator dbAttrValidator = new DbAttributeValidator();
    protected static final DbRelationshipValidator dbRelValidator = new DbRelationshipValidator();
    protected static final ProcedureValidator procedureValidator = new ProcedureValidator();
    protected static final ProcedureParameterValidator procedureParameterValidator = new ProcedureParameterValidator();
    protected static final SelectQueryValidator selectQueryValidator = new SelectQueryValidator();
    protected static final ProcedureQueryValidator procedureQueryValidator = new ProcedureQueryValidator();
    protected static final SQLTemplateValidator sqlTemplateValidator = new SQLTemplateValidator();

    public static void validate(ProjectPath path, Validator validator) {
        Object validatedObj = path.getObject();
        TreeNodeValidator validatorObj = null;
        if (validatedObj instanceof ObjAttribute) {
            validatorObj = objAttrValidator;
        } else if (validatedObj instanceof ObjRelationship) {
            validatorObj = objRelValidator;
        } else if (validatedObj instanceof ObjEntity) {
            validatorObj = objEntityValidator;
        } else if (validatedObj instanceof DbAttribute) {
            validatorObj = dbAttrValidator;
        } else if (validatedObj instanceof DbRelationship) {
            validatorObj = dbRelValidator;
        } else if (validatedObj instanceof DbEntity) {
            validatorObj = dbEntityValidator;
        } else if (validatedObj instanceof DataNode) {
            validatorObj = nodeValidator;
        } else if (validatedObj instanceof DataMap) {
            validatorObj = mapValidator;
        } else if (validatedObj instanceof DataDomain) {
            validatorObj = domainValidator;
        } else if (validatedObj instanceof Procedure) {
            validatorObj = procedureValidator;
        } else if (validatedObj instanceof ProcedureParameter) {
            validatorObj = procedureParameterValidator;
        } else if (validatedObj instanceof SelectQuery) {
            validatorObj = selectQueryValidator;
        } else if (validatedObj instanceof SQLTemplate) {
            validatorObj = sqlTemplateValidator;
        } else if (validatedObj instanceof ProcedureQuery) {
            validatorObj = procedureQueryValidator;
        } else {
            return;
        }
        ((TreeNodeValidator)validatorObj).validateObject(path, validator);
    }

    public abstract void validateObject(ProjectPath var1, Validator var2);
}

