/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.jpa.CayenneEntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCheckingEntityManager
implements CayenneEntityManager {
    protected CayenneEntityManager entityManager;

    public TypeCheckingEntityManager(CayenneEntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected void checkEntityType(Class entityClass) throws IllegalArgumentException {
        if (entityClass == null) {
            throw new IllegalArgumentException("Null entity class");
        }
        if (!Persistent.class.isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException("Entity class must be Persistent, got: " + entityClass.getName());
        }
    }

    protected void checkEntityType(Object entity) throws IllegalArgumentException {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity");
        }
        if (!(entity instanceof Persistent)) {
            String className = entity != null ? entity.getClass().getName() : "<null>";
            throw new IllegalArgumentException("entity must be Persistent: " + className);
        }
    }

    protected void enhance(Class entityClass) {
    }

    public void clear() {
        this.entityManager.clear();
    }

    public void close() {
        this.entityManager.close();
    }

    public boolean contains(Object entity) {
        this.checkEntityType(entity);
        return this.entityManager.contains(entity);
    }

    public Query createNamedQuery(String name) {
        return this.entityManager.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        this.checkEntityType(resultClass);
        return this.entityManager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.entityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    public Query createNativeQuery(String sqlString) {
        return this.entityManager.createNativeQuery(sqlString);
    }

    public Query createQuery(String ejbqlString) {
        return this.entityManager.createQuery(ejbqlString);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.checkEntityType(entityClass);
        return (T)this.entityManager.find(entityClass, primaryKey);
    }

    public void flush() {
        this.entityManager.flush();
    }

    @Override
    public DataChannel getChannel() {
        return this.entityManager.getChannel();
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.entityManager.getReference(entityClass, primaryKey);
    }

    public EntityTransaction getTransaction() {
        return this.entityManager.getTransaction();
    }

    public boolean isOpen() {
        return this.entityManager.isOpen();
    }

    public void joinTransaction() {
        this.entityManager.joinTransaction();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.entityManager.lock(entity, lockMode);
    }

    public <T> T merge(T entity) {
        this.checkEntityType(entity);
        return (T)this.entityManager.merge(entity);
    }

    public void persist(Object entity) {
        this.checkEntityType(entity);
        this.entityManager.persist(entity);
    }

    public void refresh(Object entity) {
        this.entityManager.refresh(entity);
    }

    public void remove(Object entity) {
        this.checkEntityType(entity);
        this.entityManager.remove(entity);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.entityManager.setFlushMode(flushMode);
    }
}

