/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.types.DefaultType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLActionBuilder;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class HSQLDBAdapter
extends JdbcAdapter {
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new ShortType());
        map.registerType(new ByteType());
    }

    protected String getTableName(DbEntity entity) {
        return entity.getFullyQualifiedName();
    }

    protected String getSchemaName(DbEntity entity) {
        if (entity.getSchema() != null && entity.getSchema().length() > 0) {
            return entity.getSchema() + ".";
        }
        return "";
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new HSQLActionBuilder(this, node.getEntityResolver()));
    }

    public String createUniqueConstraint(DbEntity source, Collection columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.");
        }
        String srcName = this.getTableName(source);
        StringBuffer buf = new StringBuffer();
        buf.append("ALTER TABLE ").append(srcName);
        buf.append(" ADD CONSTRAINT ");
        buf.append(this.getSchemaName(source));
        buf.append("U_");
        buf.append(source.getName());
        buf.append("_");
        buf.append((long)((double)System.currentTimeMillis() / (Math.random() * 100000.0)));
        buf.append(" UNIQUE (");
        Iterator it = columns.iterator();
        DbAttribute first = (DbAttribute)it.next();
        buf.append(first.getName());
        while (it.hasNext()) {
            DbAttribute next = (DbAttribute)it.next();
            buf.append(", ");
            buf.append(next.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public String createFkConstraint(DbRelationship rel) {
        StringBuffer buf = new StringBuffer();
        StringBuffer refBuf = new StringBuffer();
        String srcName = this.getTableName((DbEntity)rel.getSourceEntity());
        String dstName = this.getTableName((DbEntity)rel.getTargetEntity());
        buf.append("ALTER TABLE ");
        buf.append(srcName);
        buf.append(" ADD CONSTRAINT ");
        buf.append(this.getSchemaName((DbEntity)rel.getSourceEntity()));
        buf.append("C_");
        buf.append(rel.getSourceEntity().getName());
        buf.append("_");
        buf.append((long)((double)System.currentTimeMillis() / (Math.random() * 100000.0)));
        buf.append(" FOREIGN KEY (");
        Iterator jit = rel.getJoins().iterator();
        boolean first = true;
        while (jit.hasNext()) {
            DbJoin join = (DbJoin)jit.next();
            if (!first) {
                buf.append(", ");
                refBuf.append(", ");
            } else {
                first = false;
            }
            buf.append(join.getSourceName());
            refBuf.append(join.getTargetName());
        }
        buf.append(") REFERENCES ");
        buf.append(dstName);
        buf.append(" (");
        buf.append(refBuf.toString());
        buf.append(')');
        buf.append(" ON DELETE CASCADE");
        return buf.toString();
    }

    public String createTable(DbEntity ent) {
        String sql = super.createTable(ent);
        if (sql != null && sql.toUpperCase().startsWith("CREATE TABLE ")) {
            sql = "CREATE CACHED TABLE " + sql.substring("CREATE TABLE ".length());
        }
        return sql;
    }

    final class ByteType
    extends DefaultType {
        ByteType() {
            super((class$java$lang$Byte == null ? (class$java$lang$Byte = HSQLDBAdapter.class$("java.lang.Byte")) : class$java$lang$Byte).getName());
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val == null) {
                super.setJdbcObject(st, val, pos, type, precision);
            } else {
                byte b = ((Number)val).byteValue();
                st.setByte(pos, b);
            }
        }
    }

    final class ShortType
    extends DefaultType {
        ShortType() {
            super((class$java$lang$Short == null ? (class$java$lang$Short = HSQLDBAdapter.class$("java.lang.Short")) : class$java$lang$Short).getName());
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val == null) {
                super.setJdbcObject(st, val, pos, type, precision);
            } else {
                short s = ((Number)val).shortValue();
                st.setShort(pos, s);
            }
        }
    }
}

