/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.trans.ProcedureTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;

public class ProcedureAction
extends BaseSQLAction {
    protected ProcedureQuery query;
    protected int processedResultSets;

    public ProcedureAction(ProcedureQuery query, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        ProcedureTranslator transl = this.createTranslator(connection);
        CallableStatement statement = (CallableStatement)transl.createStatement();
        try {
            statement.execute();
            this.readProcedureOutParameters(statement, observer);
            while (true) {
                if (statement.getMoreResults()) {
                    ResultSet rs = statement.getResultSet();
                    try {
                        RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, observer);
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex) {}
                    }
                    continue;
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                QueryLogger.logUpdateCount(updateCount);
                observer.nextCount(this.query, updateCount);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException ex) {}
        }
    }

    protected ProcedureTranslator createTranslator(Connection connection) {
        ProcedureTranslator translator = new ProcedureTranslator();
        translator.setAdapter(this.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.getEntityResolver());
        translator.setConnection(connection);
        return translator;
    }

    protected RowDescriptor describeResultSet(ResultSet resultSet, int setIndex) {
        if (setIndex < 0) {
            throw new IllegalArgumentException("Expected a non-negative result set index. Got: " + setIndex);
        }
        List descriptors = this.query.getResultDescriptors();
        if (descriptors.isEmpty()) {
            return new RowDescriptor(resultSet, this.getAdapter().getExtendedTypes());
        }
        if (setIndex >= descriptors.size() || descriptors.get(setIndex) == null) {
            throw new CayenneRuntimeException("No descriptor for result set at index '" + setIndex + "' configured.");
        }
        ColumnDescriptor[] columns = (ColumnDescriptor[])descriptors.get(setIndex);
        return new RowDescriptor(columns, this.getAdapter().getExtendedTypes());
    }

    protected Procedure getProcedure() {
        return this.getEntityResolver().lookupProcedure(this.query);
    }

    protected void readProcedureOutParameters(CallableStatement statement, OperationObserver delegate) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        HashMap<String, Object> result = null;
        List parameters = this.getProcedure().getCallParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            ProcedureParameter parameter = (ProcedureParameter)parameters.get(i);
            if (!parameter.isOutParam()) continue;
            if (result == null) {
                result = new HashMap<String, Object>();
            }
            ColumnDescriptor descriptor = new ColumnDescriptor(parameter);
            ExtendedType type = this.getAdapter().getExtendedTypes().getRegisteredType(descriptor.getJavaClass());
            Object val = type.materializeObject(statement, i + 1, descriptor.getJdbcType());
            result.put(descriptor.getLabel(), val);
        }
        if (result != null && !result.isEmpty()) {
            QueryLogger.logSelectCount(1, System.currentTimeMillis() - t1);
            delegate.nextDataRows((Query)this.query, Collections.singletonList(result));
        }
    }
}

