/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLException;

abstract class EJBQLMultiColumnOperand {
    EJBQLTranslationContext context;
    Map map;

    EJBQLMultiColumnOperand() {
    }

    static EJBQLMultiColumnOperand getPathOperand(EJBQLTranslationContext context, Map pathMap) {
        return new PathMultiColumnOperand(context, pathMap);
    }

    static EJBQLMultiColumnOperand getObjectOperand(EJBQLTranslationContext context, Map object) {
        return new ObjectMultiColumnOperand(context, object);
    }

    Collection getKeys() {
        return this.map.keySet();
    }

    abstract void appendValue(Object var1);

    private static class ObjectMultiColumnOperand
    extends EJBQLMultiColumnOperand {
        ObjectMultiColumnOperand(EJBQLTranslationContext context, Map pathMap) {
            this.context = context;
            this.map = pathMap;
        }

        void appendValue(Object key) {
            Object value = this.map.get(key);
            if (value == null) {
                throw new EJBQLException("Invalid object, no match for ID column " + key);
            }
            String var = this.context.bindParameter(value);
            this.context.append(" #bind($").append(var).append(')');
        }
    }

    private static class PathMultiColumnOperand
    extends EJBQLMultiColumnOperand {
        PathMultiColumnOperand(EJBQLTranslationContext context, Map pathMap) {
            this.context = context;
            this.map = pathMap;
        }

        void appendValue(Object key) {
            Object column = this.map.get(key);
            if (column == null) {
                throw new EJBQLException("Invalid match path, no match for ID column " + key);
            }
            this.context.append(' ').append(column.toString());
        }
    }
}

