/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.EJBQLSelectTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplate;

public class EJBQLAction
extends BaseSQLAction {
    protected SQLActionVisitor actionFactory;
    protected EJBQLQuery query;

    public EJBQLAction(EJBQLQuery query, SQLActionVisitor actionFactory, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = query;
        this.actionFactory = actionFactory;
    }

    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        EJBQLCompiledExpression compiledExpression = this.query.getExpression(this.getEntityResolver());
        final EJBQLTranslationContext context = new EJBQLTranslationContext(compiledExpression, this.query.getParameters());
        compiledExpression.getExpression().visit(new EJBQLBaseVisitor(false){

            public boolean visitSelect(EJBQLExpression expression) {
                EJBQLSelectTranslator visitor = new EJBQLSelectTranslator(context);
                expression.visit(visitor);
                return false;
            }

            public boolean visitDelete(EJBQLExpression expression) {
                throw new UnsupportedOperationException("Not yet implemented");
            }

            public boolean visitUpdate(EJBQLExpression expression) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        });
        SQLTemplate sqlQuery = context.getQuery();
        this.actionFactory.sqlAction(sqlQuery).performAction(connection, observer);
    }
}

