/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.commons.collections.Transformer;

class DataNodeSyncQualifierDescriptor {
    private List attributes;
    private List valueTransformers;
    private boolean usingOptimisticLocking;

    DataNodeSyncQualifierDescriptor() {
    }

    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    List getAttributes() {
        return this.attributes;
    }

    Map createQualifierSnapshot(ObjectDiff diff) {
        int len = this.attributes.size();
        HashMap<String, Object> map = new HashMap<String, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = (DbAttribute)this.attributes.get(i);
            if (map.containsKey(attribute.getName())) continue;
            Object value = ((Transformer)this.valueTransformers.get(i)).transform((Object)diff);
            map.put(attribute.getName(), value);
        }
        return map;
    }

    void reset(ObjEntity entity, DbEntity dbEntity) {
        Attribute attribute;
        this.attributes = new ArrayList(3);
        this.valueTransformers = new ArrayList(3);
        boolean bl = this.usingOptimisticLocking = entity.getLockType() == 1;
        if (entity.getDbEntity() == dbEntity) {
            Iterator pkIt = entity.getDbEntity().getPrimaryKey().iterator();
            while (pkIt.hasNext()) {
                attribute = (DbAttribute)pkIt.next();
                this.attributes.add(attribute);
                this.valueTransformers.add(new Transformer((DbAttribute)attribute){
                    private final /* synthetic */ DbAttribute val$attribute;
                    {
                        this.val$attribute = dbAttribute;
                    }

                    public Object transform(Object input) {
                        ObjectId id = (ObjectId)((ObjectDiff)input).getNodeId();
                        return id.getIdSnapshot().get(this.val$attribute.getName());
                    }
                });
            }
        } else {
            DbRelationship masterDependentDbRel = this.findMasterToDependentDbRelationship(entity.getDbEntity(), dbEntity);
            if (masterDependentDbRel != null) {
                Iterator joinsIterator = masterDependentDbRel.getJoins().iterator();
                while (joinsIterator.hasNext()) {
                    final DbJoin dbAttrPair = (DbJoin)joinsIterator.next();
                    DbAttribute dbAttribute = dbAttrPair.getTarget();
                    if (this.attributes.contains(dbAttribute)) continue;
                    this.attributes.add(dbAttribute);
                    this.valueTransformers.add(new Transformer(){

                        public Object transform(Object input) {
                            ObjectId id = (ObjectId)((ObjectDiff)input).getNodeId();
                            return id.getIdSnapshot().get(dbAttrPair.getSourceName());
                        }
                    });
                }
            }
        }
        if (this.usingOptimisticLocking) {
            Iterator attributeIt = entity.getAttributes().iterator();
            while (attributeIt.hasNext()) {
                DbAttribute dbAttribute;
                attribute = (ObjAttribute)attributeIt.next();
                if (!((ObjAttribute)attribute).isUsedForLocking() || this.attributes.contains(dbAttribute = (DbAttribute)((ObjAttribute)attribute).getDbPathIterator().next())) continue;
                this.attributes.add(dbAttribute);
                this.valueTransformers.add(new Transformer((ObjAttribute)attribute){
                    private final /* synthetic */ ObjAttribute val$attribute;
                    {
                        this.val$attribute = objAttribute;
                    }

                    public Object transform(Object input) {
                        return ((ObjectDiff)input).getSnapshotValue(this.val$attribute.getName());
                    }
                });
            }
            Iterator relationshipIt = entity.getRelationships().iterator();
            while (relationshipIt.hasNext()) {
                final ObjRelationship relationship = (ObjRelationship)relationshipIt.next();
                if (!relationship.isUsedForLocking()) continue;
                DbRelationship dbRelationship = (DbRelationship)relationship.getDbRelationships().get(0);
                Iterator joinsIterator = dbRelationship.getJoins().iterator();
                while (joinsIterator.hasNext()) {
                    final DbJoin dbAttrPair = (DbJoin)joinsIterator.next();
                    DbAttribute dbAttribute = dbAttrPair.getSource();
                    int index = this.attributes.indexOf(dbAttribute);
                    if (index >= 0 && !dbAttribute.isForeignKey()) continue;
                    Transformer transformer = new Transformer(){

                        public Object transform(Object input) {
                            ObjectId targetId = ((ObjectDiff)input).getArcSnapshotValue(relationship.getName());
                            return targetId != null ? targetId.getIdSnapshot().get(dbAttrPair.getTargetName()) : null;
                        }
                    };
                    if (index < 0) {
                        this.attributes.add(dbAttribute);
                        this.valueTransformers.add(transformer);
                        continue;
                    }
                    this.valueTransformers.set(index, transformer);
                }
            }
        }
    }

    private DbRelationship findMasterToDependentDbRelationship(DbEntity masterDbEntity, DbEntity dependentDbEntity) {
        Iterator it = masterDbEntity.getRelationshipMap().values().iterator();
        while (it.hasNext()) {
            DbRelationship relationship = (DbRelationship)it.next();
            if (!dependentDbEntity.equals(relationship.getTargetEntity()) || !relationship.isToDependentPK()) continue;
            if (relationship.isToMany()) {
                throw new CayenneRuntimeException("Only 'to one' master-detail relationships can be processed.");
            }
            return relationship;
        }
        return null;
    }
}

