/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;

public abstract class PersistentObject
implements Persistent {
    protected ObjectId objectId;
    protected int persistenceState = 1;
    protected transient ObjectContext objectContext;

    public int getPersistenceState() {
        return this.persistenceState;
    }

    public void setPersistenceState(int persistenceState) {
        this.persistenceState = persistenceState;
        if (persistenceState == 1) {
            this.setObjectContext(null);
        }
    }

    public ObjectContext getObjectContext() {
        return this.objectContext;
    }

    public void setObjectContext(ObjectContext objectContext) {
        this.objectContext = objectContext;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public String toString() {
        String state = PersistenceState.persistenceStateName(this.getPersistenceState());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<").append(this.getClass().getName()).append("@").append(System.identityHashCode(this)).append(", id=").append(this.objectId).append(", state=").append(state).append(", context=").append(this.objectContext).append(">");
        return buffer.toString();
    }
}

