/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.CayenneContextGraphAction;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.CayenneContextMergeHandler;
import org.apache.cayenne.CayenneContextQueryAction;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectContextDeleteAction;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.Validating;
import org.apache.cayenne.cache.MapQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationResult;

public class CayenneContext
extends BaseContext {
    protected EntityResolver entityResolver;
    CayenneContextGraphManager graphManager;
    CayenneContextGraphAction graphAction = new CayenneContextGraphAction(this);
    CayenneContextMergeHandler mergeHandler;
    QueryCache queryCache;

    public CayenneContext() {
        this(null);
    }

    public CayenneContext(DataChannel channel) {
        this(channel, false, false);
    }

    public CayenneContext(DataChannel channel, boolean changeEventsEnabled, boolean syncEventsEnabled) {
        this.graphManager = new CayenneContextGraphManager(this, changeEventsEnabled, syncEventsEnabled);
        this.setChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryCache getQueryCache() {
        if (this.queryCache == null) {
            CayenneContext cayenneContext = this;
            synchronized (cayenneContext) {
                if (this.queryCache == null) {
                    this.queryCache = new MapQueryCache();
                }
            }
        }
        return this.queryCache;
    }

    public void setChannel(DataChannel channel) {
        if (this.channel != channel) {
            EventManager eventManager;
            if (this.mergeHandler != null) {
                this.mergeHandler.active = false;
                this.mergeHandler = null;
            }
            this.channel = channel;
            EventManager eventManager2 = eventManager = channel != null ? channel.getEventManager() : null;
            if (eventManager != null) {
                this.mergeHandler = new CayenneContextMergeHandler(this);
                EventUtil.listenForChannelEvents(channel, (DataChannelListener)this.mergeHandler);
            }
        }
    }

    public boolean isChangeEventsEnabled() {
        return this.graphManager.changeEventsEnabled;
    }

    public boolean isLifecycleEventsEnabled() {
        return this.graphManager.lifecycleEventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            CayenneContext cayenneContext = this;
            synchronized (cayenneContext) {
                if (this.entityResolver == null) {
                    this.setEntityResolver(this.channel.getEntityResolver());
                }
            }
        }
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    CayenneContextGraphManager internalGraphManager() {
        return this.graphManager;
    }

    CayenneContextGraphAction internalGraphAction() {
        return this.graphAction;
    }

    public void commitChanges() {
        this.doCommitChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff doCommitChanges(boolean cascade) {
        int syncType = cascade ? 2 : 1;
        GraphDiff commitDiff = null;
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                ValidationResult result = new ValidationResult();
                Iterator it = this.graphManager.dirtyNodes().iterator();
                while (it.hasNext()) {
                    Persistent p = (Persistent)it.next();
                    if (!(p instanceof Validating)) continue;
                    switch (p.getPersistenceState()) {
                        case 2: {
                            ((Validating)((Object)p)).validateForInsert(result);
                            break;
                        }
                        case 4: {
                            ((Validating)((Object)p)).validateForUpdate(result);
                            break;
                        }
                        case 6: {
                            ((Validating)((Object)p)).validateForDelete(result);
                        }
                    }
                }
                if (result.hasFailures()) {
                    throw new ValidationException(result);
                }
                this.graphManager.graphCommitStarted();
                try {
                    commitDiff = this.channel.onSync(this, this.graphManager.getDiffsSinceLastFlush(), syncType);
                }
                catch (Throwable th) {
                    this.graphManager.graphCommitAborted();
                    if (th instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)th;
                    }
                    throw new CayenneRuntimeException("Commit error", th);
                }
                this.graphManager.graphCommitted(commitDiff);
            }
        }
        return commitDiff;
    }

    public void commitChangesToParent() {
        this.doCommitChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                GraphDiff diff = this.graphManager.getDiffs();
                this.graphManager.graphReverted();
                this.channel.onSync(this, diff, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChangesLocally() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                this.graphManager.graphReverted();
            }
        }
    }

    public void deleteObject(Object object) {
        new ObjectContextDeleteAction(this).performDelete((Persistent)object);
    }

    public Persistent newObject(Class persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Persistent class can't be null.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(persistentClass);
        if (entity == null) {
            throw new CayenneRuntimeException("No entity mapped for class: " + persistentClass);
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        Persistent object = (Persistent)descriptor.createObject();
        this.registerNewObject(object, entity.getName(), descriptor);
        return object;
    }

    public void registerNewObject(Object object) {
        if (object == null) {
            throw new NullPointerException("An attempt to register null object.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object.getClass());
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        this.registerNewObject((Persistent)object, entity.getName(), descriptor);
    }

    public List performQuery(Query query) {
        List result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    public QueryResponse performGenericQuery(Query query) {
        return this.onQuery(this, query);
    }

    QueryResponse onQuery(ObjectContext context, Query query) {
        return new CayenneContextQueryAction(this, context, query).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent localObject(ObjectId id, Object prototype) {
        Persistent localObject;
        if (id == null) {
            throw new IllegalArgumentException("Null ObjectId");
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        Persistent cachedObject = (Persistent)this.getGraphManager().getNode(id);
        if (cachedObject != null) {
            if (cachedObject != prototype && cachedObject.getPersistenceState() != 4 && cachedObject.getPersistenceState() != 6 && prototype != null && ((Persistent)prototype).getPersistenceState() != 5) {
                descriptor.shallowMerge(prototype, cachedObject);
                if (cachedObject.getPersistenceState() == 5) {
                    cachedObject.setPersistenceState(3);
                }
            }
            return cachedObject;
        }
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            localObject = (Persistent)descriptor.createObject();
            localObject.setObjectContext(this);
            localObject.setObjectId(id);
            this.getGraphManager().registerNode(id, localObject);
        }
        if (prototype != null) {
            localObject.setPersistenceState(3);
            descriptor.shallowMerge(prototype, localObject);
        } else {
            localObject.setPersistenceState(5);
        }
        return localObject;
    }

    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        this.graphAction.handlePropertyChange(object, property, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection uncommittedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection deletedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection modifiedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection newObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNewObject(Persistent object, String entityName, ClassDescriptor descriptor) {
        ObjectId id = new ObjectId(entityName);
        object.setObjectId(id);
        object.setObjectContext(this);
        object.setPersistenceState(2);
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            this.graphManager.registerNode(object.getObjectId(), object);
            this.graphManager.nodeCreated(object.getObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Persistent createFault(ObjectId id) {
        Persistent object;
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            object = (Persistent)descriptor.createObject();
            object.setPersistenceState(5);
            object.setObjectContext(this);
            object.setObjectId(id);
            this.graphManager.registerNode(id, object);
        }
        return object;
    }
}

