/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ExtendedEnumeration;
import org.apache.cayenne.access.types.AbstractType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEnumType<T extends Enum<T>>
implements ExtendedType {
    private Class<T> enumerationClass = null;
    private Object[] values = null;
    private Map<Object, Enum<T>> enumerationMappings = new HashMap<Object, Enum<T>>();

    public ExtendedEnumType(Class<T> enumerationClass) {
        if (enumerationClass == null) {
            throw new IllegalArgumentException("Null ExtendedEnumType class");
        }
        this.enumerationClass = enumerationClass;
        try {
            Method m = enumerationClass.getMethod("values", new Class[0]);
            this.values = (Object[])m.invoke(null, new Object[0]);
            for (int i = 0; i < this.values.length; ++i) {
                this.register((Enum)this.values[i], ((ExtendedEnumeration)this.values[i]).getDatabaseValue());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class " + enumerationClass.getName() + " is not an Enum", e);
        }
    }

    @Override
    public String getClassName() {
        return this.enumerationClass.getName();
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : this.lookup(i);
        }
        String string = rs.getString(index);
        return string != null ? this.lookup(string) : null;
    }

    @Override
    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : this.lookup(i);
        }
        String string = rs.getString(index);
        return string != null ? this.lookup(string) : null;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        if (value instanceof ExtendedEnumeration) {
            ExtendedEnumeration e = (ExtendedEnumeration)value;
            if (TypesMapping.isNumeric(type)) {
                statement.setInt(pos, (Integer)e.getDatabaseValue());
            } else {
                statement.setString(pos, (String)e.getDatabaseValue());
            }
        } else {
            statement.setNull(pos, type);
        }
    }

    @Override
    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return AbstractType.validateNull(source, property, value, dbAttribute, validationResult);
    }

    private void register(Enum<T> enumeration, Object databaseValue) {
        if (this.enumerationMappings.containsKey(databaseValue) || this.enumerationMappings.containsValue(enumeration)) {
            throw new CayenneRuntimeException("Enumerations/values may not be duplicated.");
        }
        this.enumerationMappings.put(databaseValue, enumeration);
    }

    private Enum<T> lookup(Object databaseValue) {
        if (!this.enumerationMappings.containsKey(databaseValue)) {
            if (databaseValue instanceof Integer) {
                throw new CayenneRuntimeException("Missing enumeration mapping for " + this.getClassName() + " with value " + databaseValue + ".");
            }
            return Enum.valueOf(this.enumerationClass, (String)databaseValue);
        }
        return this.enumerationMappings.get(databaseValue);
    }

    public Map<Object, Enum<T>> getEnumerationMappings() {
        return this.enumerationMappings;
    }

    public Object[] getValues() {
        return this.values;
    }
}

