/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cassandra.utils.AbstractStatsDeque;
import org.apache.cassandra.utils.Tuple;

public class TimedStatsDeque
extends AbstractStatsDeque {
    private final ArrayDeque<Tuple> deque;
    private final long period;

    public TimedStatsDeque(long period) {
        this.period = period;
        this.deque = new ArrayDeque();
    }

    private void purge() {
        long now = System.currentTimeMillis();
        while (!this.deque.isEmpty() && this.deque.peek().timestamp < now - this.period) {
            this.deque.remove();
        }
    }

    @Override
    public synchronized Iterator<Double> iterator() {
        this.purge();
        ArrayList<Double> L = new ArrayList<Double>(this.deque.size());
        for (Tuple t : this.deque) {
            L.add(t.value);
        }
        return L.iterator();
    }

    @Override
    public synchronized int size() {
        this.purge();
        return this.deque.size();
    }

    @Override
    public synchronized void add(double o) {
        this.purge();
        this.deque.add(new Tuple(o, System.currentTimeMillis()));
    }

    @Override
    public synchronized void clear() {
        this.deque.clear();
    }
}

