/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class FBUtilities {
    private static Logger logger_ = Logger.getLogger(FBUtilities.class);
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static InetAddress localInetAddress_;

    public static String getTimestamp() {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return df.format(date);
    }

    public static String getTimestamp(long value) {
        Date date = new Date(value);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return df.format(date);
    }

    public static int getBits(int x, int p, int n) {
        return x >>> p + 1 - n & ~(-1 << n);
    }

    public static String getCurrentThreadStackTrace() {
        Throwable throwable = new Throwable();
        StackTraceElement[] ste = throwable.getStackTrace();
        StringBuilder sbuf = new StringBuilder();
        for (int i = ste.length - 1; i > 0; --i) {
            sbuf.append(ste[i].getClassName()).append(".").append(ste[i].getMethodName()).append("/");
        }
        sbuf.deleteCharAt(sbuf.length() - 1);
        return sbuf.toString();
    }

    public static String[] strip(String string, String token) {
        StringTokenizer st = new StringTokenizer(string, token);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add((String)st.nextElement());
        }
        return result.toArray(new String[0]);
    }

    public static byte[] serializeToStream(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[]{};
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            LogUtil.getLogger(FBUtilities.class.getName()).info((Object)LogUtil.throwableToString(e));
        }
        return bytes;
    }

    public static Object deserializeFromStream(byte[] bytes) {
        Object o = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                o = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            LogUtil.getLogger(FBUtilities.class.getName()).info((Object)LogUtil.throwableToString(e));
        }
        return o;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        if (localInetAddress_ == null) {
            localInetAddress_ = InetAddress.getLocalHost();
        }
        return localInetAddress_;
    }

    public static String getHostAddress() throws UnknownHostException {
        InetAddress inetAddr = FBUtilities.getLocalAddress();
        if (DatabaseDescriptor.getListenAddress() != null) {
            inetAddr = InetAddress.getByName(DatabaseDescriptor.getListenAddress());
        }
        return inetAddr.getHostAddress();
    }

    public static boolean isHostLocalHost(InetAddress host) {
        try {
            return FBUtilities.getLocalAddress().equals(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static byte[] toByteArray(int i) {
        byte[] bytes = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return bytes;
    }

    public static int byteArrayToInt(byte[] bytes) {
        return FBUtilities.byteArrayToInt(bytes, 0);
    }

    public static int byteArrayToInt(byte[] bytes, int offset) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("An integer must be 4 bytes in size.");
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n |= bytes[offset + i] & 0xFF;
        }
        return n;
    }

    public static boolean isEqualBits(byte[] bytes1, byte[] bytes2) {
        return 0 == FBUtilities.compareByteArrays(bytes1, bytes2);
    }

    public static int compareByteArrays(byte[] bytes1, byte[] bytes2) {
        if (null == bytes1) {
            if (null == bytes2) {
                return 0;
            }
            return -1;
        }
        if (null == bytes2) {
            return 1;
        }
        for (int i = 0; i < bytes1.length && i < bytes2.length; ++i) {
            int cmp = FBUtilities.compareBytes(bytes1[i], bytes2[i]);
            if (0 == cmp) continue;
            return cmp;
        }
        if (bytes1.length == bytes2.length) {
            return 0;
        }
        return bytes1.length < bytes2.length ? -1 : 1;
    }

    public static int compareBytes(byte b1, byte b2) {
        return FBUtilities.compareBytes((int)b1, (int)b2);
    }

    public static int compareBytes(int b1, int b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        if (i1 < i2) {
            return -1;
        }
        if (i1 == i2) {
            return 0;
        }
        return 1;
    }

    public static String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static BigInteger hash(String data) {
        byte[] result = FBUtilities.hash("MD5", data.getBytes());
        BigInteger hash = new BigInteger(result);
        return hash.abs();
    }

    public static byte[] hash(String type, byte[] data) {
        byte[] result;
        block2: {
            result = null;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(type);
                result = messageDigest.digest(data);
            }
            catch (Exception e) {
                if (!logger_.isDebugEnabled()) break block2;
                logger_.debug((Object)LogUtil.throwableToString(e));
            }
        }
        return result;
    }

    public static boolean isEqual(byte[] digestA, byte[] digestB) {
        return MessageDigest.isEqual(digestA, digestB);
    }

    public static void compressToStream(byte[] input, ByteArrayOutputStream bos) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
    }

    public static byte[] compress(byte[] input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        FBUtilities.compressToStream(input, bos);
        bos.close();
        return bos.toByteArray();
    }

    public static byte[] decompress(byte[] compressedData, int off, int len) throws IOException, DataFormatException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData, off, len);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buf);
            bos.write(buf, 0, count);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static byte[] decompress(byte[] compressedData) throws IOException, DataFormatException {
        return FBUtilities.decompress(compressedData, 0, compressedData.length);
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        byte[] bMore;
        byte[] bLess;
        assert (b1 != null);
        assert (b2 != null);
        if (b1.length > b2.length) {
            bLess = b2;
            bMore = b1;
        } else {
            bLess = b1;
            bMore = b2;
        }
        for (int i = 0; i < bLess.length; ++i) {
            bMore[i] = (byte)(bMore[i] ^ bLess[i]);
        }
        return bMore;
    }

    public static int getUTF8Length(String string) {
        String utfName = string;
        int length = utfName.length();
        try {
            length = string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.getLogger(FBUtilities.class.getName()).info((Object)LogUtil.throwableToString(e));
        }
        return length;
    }

    public static void writeByteArray(byte[] bytes, DataOutput out) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        if (length > 0) {
            in.readFully(bytes);
        }
        return bytes;
    }

    public static byte[] hexToBytes(String str) {
        assert (str.length() % 2 == 0);
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(i, i + 2), 16);
        }
        return bytes;
    }

    public static String bytesToHex(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        for (int i = 0; i < buf.length; ++i) {
            chars[i * 2] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[i * 2 + 1] = HEX_CHARS[buf[i] & 0xF];
        }
        return new String(chars);
    }

    public static String mapToString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        return sb.append("}").toString();
    }
}

