/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cassandra.utils.ICacheExpungeHook;
import org.apache.cassandra.utils.ICachetable;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class Cachetable<K, V>
implements ICachetable<K, V> {
    private ICacheExpungeHook<K, V> globalHook_;
    private Hashtable<K, CacheableObject<V>> cache_;
    private Map<K, ICacheExpungeHook<K, V>> hooks_;
    private Timer timer_;
    private static int counter_ = 0;
    private static Logger logger_ = Logger.getLogger(Cachetable.class);

    private void init(long expiration) {
        if (expiration <= 0L) {
            throw new IllegalArgumentException("Argument specified must be a positive number");
        }
        this.cache_ = new Hashtable();
        this.hooks_ = new Hashtable<K, ICacheExpungeHook<K, V>>();
        this.timer_ = new Timer("CACHETABLE-TIMER-" + ++counter_, true);
        this.timer_.schedule((TimerTask)new CacheMonitor(expiration), expiration, expiration);
    }

    public Cachetable(long expiration) {
        this.init(expiration);
    }

    public Cachetable(long expiration, ICacheExpungeHook<K, V> global) {
        this.init(expiration);
        this.globalHook_ = global;
    }

    @Override
    public void shutdown() {
        this.timer_.cancel();
    }

    @Override
    public void put(K key, V value) {
        this.cache_.put(key, new CacheableObject<V>(value));
    }

    @Override
    public void put(K key, V value, ICacheExpungeHook<K, V> hook) {
        this.put(key, value);
        this.hooks_.put(key, hook);
    }

    @Override
    public V get(K key) {
        V result = null;
        CacheableObject<V> co = this.cache_.get(key);
        if (co != null) {
            result = co.getValue();
        }
        return result;
    }

    @Override
    public V remove(K key) {
        CacheableObject<V> co = this.cache_.remove(key);
        V result = null;
        if (co != null) {
            result = co.getValue();
        }
        return result;
    }

    @Override
    public int size() {
        return this.cache_.size();
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache_.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.cache_.containsValue(new CacheableObject<V>(value));
    }

    @Override
    public boolean isEmpty() {
        return this.cache_.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.cache_.keySet();
    }

    private class CacheMonitor
    extends TimerTask {
        private long expiration_;

        CacheMonitor(long expiration) {
            this.expiration_ = expiration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap expungedValues = new HashMap();
            Hashtable hashtable = Cachetable.this.cache_;
            synchronized (hashtable) {
                Enumeration e = Cachetable.this.cache_.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    CacheableObject co = (CacheableObject)Cachetable.this.cache_.get(key);
                    if (co == null || !co.isReadyToDie(this.expiration_)) continue;
                    Object v = co.getValue();
                    if (null != v) {
                        expungedValues.put(key, v);
                    }
                    Cachetable.this.cache_.remove(key);
                }
            }
            Set keys = expungedValues.keySet();
            for (Object key : keys) {
                Object value = expungedValues.get(key);
                ICacheExpungeHook hook = (ICacheExpungeHook)Cachetable.this.hooks_.remove(key);
                try {
                    if (hook != null) {
                        hook.callMe(key, value);
                        continue;
                    }
                    if (Cachetable.this.globalHook_ == null) continue;
                    Cachetable.this.globalHook_.callMe(key, value);
                }
                catch (Throwable e) {
                    logger_.info((Object)LogUtil.throwableToString(e));
                }
            }
            expungedValues.clear();
        }
    }

    private class CacheableObject<V> {
        private V value_;
        private long age_;

        CacheableObject(V o) {
            this.value_ = o;
            this.age_ = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            return this.value_.equals(o);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        V getValue() {
            return this.value_;
        }

        boolean isReadyToDie(long expiration) {
            return System.currentTimeMillis() - this.age_ > expiration;
        }
    }
}

