/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class TokenUpdater {
    private static final int port_ = 7000;
    private static final long waitTime_ = 10000L;

    public static void main(String[] args) throws Throwable {
        if (args.length != 3) {
            System.out.println("Usage : java org.apache.cassandra.tools.TokenUpdater <ip:port> <token> <file containing node token info>");
            System.exit(1);
        }
        String ipPort = args[0];
        IPartitioner p = StorageService.getPartitioner();
        Token token = p.getTokenFactory().fromString(args[1]);
        String file = args[2];
        String[] ipPortPair = ipPort.split(":");
        EndPoint target = new EndPoint(ipPortPair[0], Integer.valueOf(ipPortPair[1]));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Token.serializer().serialize(token, dos);
        Message tokenUpdateMessage = new Message(new EndPoint(FBUtilities.getHostAddress(), 7000), "", "TOKEN-VERB-HANDLER", bos.toByteArray());
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            String[] nodeTokenPair = line.split(" ");
            Token nodeToken = p.getTokenFactory().fromString(nodeTokenPair[1]);
            tokenUpdateMessage.addHeader(nodeTokenPair[0], p.getTokenFactory().toByteArray(nodeToken));
        }
        System.out.println("Sending a token update message to " + target);
        MessagingService.getMessagingInstance().sendOneWay(tokenUpdateMessage, target);
        Thread.sleep(10000L);
        System.out.println("Done sending the update message");
    }
}

