/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.FBUtilities;

public class MembershipCleaner {
    private static final int port_ = 7000;
    private static final long waitTime_ = 10000L;

    public static void main(String[] args) throws Throwable {
        if (args.length != 3) {
            System.out.println("Usage : java org.apache.cassandra.tools.MembershipCleaner <ip:port to send the message> <node which needs to be removed> <file containing all nodes in the cluster>");
            System.exit(1);
        }
        String ipPort = args[0];
        String node = args[1];
        String file = args[2];
        String[] ipPortPair = ipPort.split(":");
        EndPoint target = new EndPoint(ipPortPair[0], Integer.valueOf(ipPortPair[1]));
        MembershipCleanerMessage mcMessage = new MembershipCleanerMessage(node);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        MembershipCleanerMessage.serializer().serialize(mcMessage, dos);
        Message mbrshipCleanerMessage = new Message(new EndPoint(FBUtilities.getHostAddress(), 7000), "", "MBRSHIP-CLEANER-VERB-HANDLER", bos.toByteArray());
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            mbrshipCleanerMessage.addHeader(line, line.getBytes());
        }
        System.out.println("Sending a membership clean message to " + target);
        MessagingService.getMessagingInstance().sendOneWay(mbrshipCleanerMessage, target);
        Thread.sleep(10000L);
        System.out.println("Done sending the update message");
    }

    public static class MembershipCleanerMessageSerializer
    implements ICompactSerializer<MembershipCleanerMessage> {
        @Override
        public void serialize(MembershipCleanerMessage mcMessage, DataOutputStream dos) throws IOException {
            dos.writeUTF(mcMessage.getTarget());
        }

        @Override
        public MembershipCleanerMessage deserialize(DataInputStream dis) throws IOException {
            return new MembershipCleanerMessage(dis.readUTF());
        }
    }

    public static class MembershipCleanerMessage
    implements Serializable {
        private static ICompactSerializer<MembershipCleanerMessage> serializer_ = new MembershipCleanerMessageSerializer();
        private String target_;

        static ICompactSerializer<MembershipCleanerMessage> serializer() {
            return serializer_;
        }

        MembershipCleanerMessage(String target) {
            this.target_ = target;
        }

        String getTarget() {
            return this.target_;
        }
    }
}

