/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LogUtil;

public class KeyChecker {
    private static final int bufSize_ = 0x8000000;

    private static boolean checkIfProcessKey(String key) {
        EndPoint[] endPoints = StorageService.instance().getReadStorageEndPoints(key);
        EndPoint localEndPoint = StorageService.getLocalStorageEndPoint();
        for (EndPoint endPoint : endPoints) {
            if (!endPoint.equals(localEndPoint)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 1) {
            System.out.println("Usage : java com.facebook.infrastructure.tools.KeyChecker <file containing all keys>");
            System.exit(1);
        }
        LogUtil.init();
        StorageService s = StorageService.instance();
        s.start();
        Thread.sleep(240000L);
        RandomAccessFile raf = new RandomAccessFile("Missing-" + FBUtilities.getHostAddress() + ".dat", "rw");
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(args[0])), 0x8000000);
        String key = null;
        boolean bStarted = false;
        while ((key = bufReader.readLine()) != null) {
            if (!bStarted) {
                bStarted = true;
                System.out.println("Started the processing of the file ...");
            }
            key = key.trim();
            if (!StorageService.instance().isPrimary(key)) continue;
            System.out.println("Processing key " + key);
            Row row = Table.open("Mailbox").getRow(key, "MailboxMailList0");
            if (!row.isEmpty()) continue;
            System.out.println("MISSING KEY : " + key);
            raf.write(key.getBytes());
            raf.write(System.getProperty("line.separator").getBytes());
        }
        System.out.println("DONE checking keys ...");
        raf.close();
    }
}

