/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.io.StreamContextManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FileUtils;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public final class StreamManager {
    private static Logger logger_ = Logger.getLogger(StreamManager.class);
    private static Map<EndPoint, StreamManager> streamManagers_ = new HashMap<EndPoint, StreamManager>();
    private List<File> filesToStream_ = new ArrayList<File>();
    private EndPoint to_;
    private long totalBytesToStream_ = 0L;

    public static StreamManager instance(EndPoint to) {
        StreamManager streamManager = streamManagers_.get(to);
        if (streamManager == null) {
            streamManager = new StreamManager(to);
            streamManagers_.put(to, streamManager);
        }
        return streamManager;
    }

    private StreamManager(EndPoint to) {
        this.to_ = to;
    }

    public void addFilesToStream(StreamContextManager.StreamContext[] streamContexts) {
        for (StreamContextManager.StreamContext streamContext : streamContexts) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Adding file " + streamContext.getTargetFile() + " to be streamed."));
            }
            this.filesToStream_.add(new File(streamContext.getTargetFile()));
            this.totalBytesToStream_ += streamContext.getExpectedBytes();
        }
    }

    void start() {
        if (this.filesToStream_.size() > 0) {
            File file = this.filesToStream_.get(0);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Streaming file " + file + " ..."));
            }
            MessagingService.getMessagingInstance().stream(file.getAbsolutePath(), 0L, file.length(), StorageService.getLocalStorageEndPoint(), this.to_);
        }
    }

    void repeat() {
        if (this.filesToStream_.size() > 0) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(String file) throws IOException {
        File f = new File(file);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Deleting file " + file + " after streaming " + f.length() + "/" + this.totalBytesToStream_ + " bytes."));
        }
        FileUtils.delete(file);
        this.filesToStream_.remove(0);
        if (this.filesToStream_.size() > 0) {
            this.start();
        } else {
            StreamManager streamManager = this;
            synchronized (streamManager) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Signalling that streaming is done for " + this.to_));
                }
                this.notifyAll();
            }
        }
    }

    public synchronized void waitForStreamCompletion() {
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            logger_.warn((Object)LogUtil.throwableToString(ex));
        }
    }

    public static class BootstrapTerminateVerbHandler
    implements IVerbHandler {
        private static Logger logger_ = Logger.getLogger(BootstrapTerminateVerbHandler.class);

        @Override
        public void doVerb(Message message) {
            byte[] body = message.getMessageBody();
            DataInputBuffer bufIn = new DataInputBuffer();
            bufIn.reset(body, body.length);
            try {
                StreamContextManager.StreamStatusMessage streamStatusMessage = StreamContextManager.StreamStatusMessage.serializer().deserialize(bufIn);
                StreamContextManager.StreamStatus streamStatus = streamStatusMessage.getStreamStatus();
                switch (streamStatus.getAction()) {
                    case DELETE: {
                        StreamManager.instance(message.getFrom()).finish(streamStatus.getFile());
                        break;
                    }
                    case STREAM: {
                        if (logger_.isDebugEnabled()) {
                            logger_.debug((Object)("Need to re-stream file " + streamStatus.getFile()));
                        }
                        StreamManager.instance(message.getFrom()).repeat();
                        break;
                    }
                }
            }
            catch (IOException ex) {
                logger_.info((Object)LogUtil.throwableToString(ex));
            }
        }
    }
}

