/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowMutationMessage;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.ReadRepairManager;
import org.apache.cassandra.service.WriteResponseResolver;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class ReadResponseResolver
implements IResponseResolver<Row> {
    private static Logger logger_ = Logger.getLogger(WriteResponseResolver.class);

    @Override
    public Row resolve(List<Message> responses) throws DigestMismatchException {
        int i;
        long startTime = System.currentTimeMillis();
        Row retRow = null;
        ArrayList<Row> rowList = new ArrayList<Row>();
        ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>();
        String key = null;
        String table = null;
        byte[] digest = new byte[]{};
        boolean isDigestQuery = false;
        DataInputBuffer bufIn = new DataInputBuffer();
        for (Message response : responses) {
            byte[] body = response.getMessageBody();
            bufIn.reset(body, body.length);
            try {
                long start = System.currentTimeMillis();
                ReadResponse result = ReadResponse.serializer().deserialize(bufIn);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Response deserialization time : " + (System.currentTimeMillis() - start) + " ms."));
                }
                if (!result.isDigestQuery()) {
                    rowList.add(result.row());
                    endPoints.add(response.getFrom());
                    key = result.row().key();
                    table = result.row().getTable();
                    continue;
                }
                digest = result.digest();
                isDigestQuery = true;
            }
            catch (IOException ex) {
                logger_.info((Object)LogUtil.throwableToString(ex));
            }
        }
        if (isDigestQuery) {
            for (Row row : rowList) {
                if (Arrays.equals(row.digest(), digest)) continue;
                throw new DigestMismatchException(row.key());
            }
        }
        if (rowList.size() == 0) {
            return retRow;
        }
        retRow = new Row(table, key);
        for (i = 0; i < rowList.size(); ++i) {
            retRow.repair((Row)rowList.get(i));
        }
        for (i = 0; i < rowList.size(); ++i) {
            Row diffRow = ((Row)rowList.get(i)).diff(retRow);
            if (diffRow == null) continue;
            RowMutation rowMutation = new RowMutation(table, key);
            for (ColumnFamily cf : diffRow.getColumnFamilies()) {
                rowMutation.add(cf);
            }
            RowMutationMessage rowMutationMessage = new RowMutationMessage(rowMutation);
            ReadRepairManager.instance().schedule((EndPoint)endPoints.get(i), rowMutationMessage);
        }
        logger_.info((Object)("resolve: " + (System.currentTimeMillis() - startTime) + " ms."));
        return retRow;
    }

    @Override
    public boolean isDataPresent(List<Message> responses) {
        boolean isDataPresent = false;
        for (Message response : responses) {
            byte[] body = response.getMessageBody();
            DataInputBuffer bufIn = new DataInputBuffer();
            bufIn.reset(body, body.length);
            try {
                ReadResponse result = ReadResponse.serializer().deserialize(bufIn);
                if (!result.isDigestQuery()) {
                    isDataPresent = true;
                }
                bufIn.close();
            }
            catch (IOException ex) {
                logger_.info((Object)LogUtil.throwableToString(ex));
            }
        }
        return isDataPresent;
    }
}

