/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.db.RangeCommand;
import org.apache.cassandra.db.RangeReply;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.log4j.Logger;

public class RangeVerbHandler
implements IVerbHandler {
    private static final Logger logger = Logger.getLogger(RangeVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        try {
            RangeCommand command = RangeCommand.read(message);
            Table table = Table.open(command.table);
            RangeReply rangeReply = table.getColumnFamilyStore(command.columnFamily).getKeyRange(command.startWith, command.stopAt, command.maxResults);
            Message response = rangeReply.getReply(message);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending " + rangeReply + " to " + message.getMessageId() + "@" + message.getFrom()));
            }
            MessagingService.getMessagingInstance().sendOneWay(response, message.getFrom());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

