/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.TimerTask;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.utils.FileUtils;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

class LoadDisseminator
extends TimerTask {
    private static final Logger logger_ = Logger.getLogger(LoadDisseminator.class);
    protected static final String loadInfo_ = "LOAD-INFORMATION";

    LoadDisseminator() {
    }

    @Override
    public void run() {
        try {
            long diskSpace = FileUtils.getUsedDiskSpace();
            String diskUtilization = FileUtils.stringifyFileSize(diskSpace);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Disseminating load info ...");
            }
            Gossiper.instance().addApplicationState(loadInfo_, new ApplicationState(diskUtilization));
        }
        catch (Throwable ex) {
            logger_.warn((Object)LogUtil.throwableToString(ex));
        }
    }
}

