/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Cachetable;
import org.apache.cassandra.utils.ICacheExpungeHook;
import org.apache.cassandra.utils.ICachetable;
import org.apache.cassandra.utils.LogUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class ConsistencyManager
implements Runnable {
    private static Logger logger_ = Logger.getLogger(ConsistencyManager.class);
    private static long scheduledTimeMillis_ = 600L;
    private static ICachetable<String, String> readRepairTable_ = new Cachetable<String, String>(scheduledTimeMillis_);
    private final Row row_;
    protected final List<EndPoint> replicas_;
    private final ReadCommand readCommand_;

    public ConsistencyManager(Row row, List<EndPoint> replicas, ReadCommand readCommand) {
        this.row_ = row;
        this.replicas_ = replicas;
        this.readCommand_ = readCommand;
    }

    @Override
    public void run() {
        ReadCommand readCommandDigestOnly = this.constructReadMessage(true);
        try {
            Message message = readCommandDigestOnly.makeReadMessage();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Reading consistency digest for " + this.readCommand_.key + " from " + message.getMessageId() + "@[" + StringUtils.join(this.replicas_, (String)", ") + "]"));
            }
            MessagingService.getMessagingInstance().sendRR(message, this.replicas_.toArray(new EndPoint[this.replicas_.size()]), (IAsyncCallback)new DigestResponseHandler());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ReadCommand constructReadMessage(boolean isDigestQuery) {
        ReadCommand readCommand = this.readCommand_.copy();
        readCommand.setDigestQuery(isDigestQuery);
        return readCommand;
    }

    static class DataRepairHandler
    implements IAsyncCallback,
    ICacheExpungeHook<String, String> {
        private List<Message> responses_ = new ArrayList<Message>();
        private IResponseResolver<Row> readResponseResolver_;
        private int majority_;

        DataRepairHandler(int responseCount, IResponseResolver<Row> readResponseResolver) {
            this.readResponseResolver_ = readResponseResolver;
            this.majority_ = (responseCount >> 1) + 1;
        }

        @Override
        public void response(Message message) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Received responses in DataRepairHandler : " + message.toString()));
            }
            this.responses_.add(message);
            if (this.responses_.size() == this.majority_) {
                String messageId = message.getMessageId();
                readRepairTable_.put(messageId, messageId, this);
            }
        }

        @Override
        public void attachContext(Object o) {
            throw new UnsupportedOperationException("This operation is not currently supported.");
        }

        @Override
        public void callMe(String key, String value) {
            this.handleResponses();
        }

        private void handleResponses() {
            try {
                this.readResponseResolver_.resolve(new ArrayList<Message>(this.responses_));
            }
            catch (DigestMismatchException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class DigestResponseHandler
    implements IAsyncCallback {
        List<Message> responses_ = new ArrayList<Message>();

        DigestResponseHandler() {
        }

        @Override
        public synchronized void response(Message msg) {
            this.responses_.add(msg);
            if (this.responses_.size() == ConsistencyManager.this.replicas_.size()) {
                this.handleDigestResponses();
            }
        }

        @Override
        public void attachContext(Object o) {
            throw new UnsupportedOperationException("This operation is not currently supported.");
        }

        private void handleDigestResponses() {
            DataInputBuffer bufIn = new DataInputBuffer();
            for (Message response : this.responses_) {
                byte[] body = response.getMessageBody();
                bufIn.reset(body, body.length);
                try {
                    ReadResponse result = ReadResponse.serializer().deserialize(bufIn);
                    byte[] digest = result.digest();
                    if (Arrays.equals(ConsistencyManager.this.row_.digest(), digest)) continue;
                    this.doReadRepair();
                    break;
                }
                catch (IOException ex) {
                    logger_.info((Object)LogUtil.throwableToString(ex));
                }
            }
        }

        private void doReadRepair() throws IOException {
            ReadResponseResolver readResponseResolver = new ReadResponseResolver();
            ConsistencyManager.this.replicas_.add(StorageService.getLocalStorageEndPoint());
            DataRepairHandler responseHandler = new DataRepairHandler(ConsistencyManager.this.replicas_.size(), readResponseResolver);
            ReadCommand readCommand = ConsistencyManager.this.constructReadMessage(false);
            Message message = readCommand.makeReadMessage();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Performing read repair for " + ((ConsistencyManager)ConsistencyManager.this).readCommand_.key + " to " + message.getMessageId() + "@[" + StringUtils.join(ConsistencyManager.this.replicas_, (String)", ") + "]"));
            }
            MessagingService.getMessagingInstance().sendRR(message, ConsistencyManager.this.replicas_.toArray(new EndPoint[ConsistencyManager.this.replicas_.size()]), (IAsyncCallback)responseHandler);
        }
    }
}

