/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import flexjson.JSONSerializer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.Cassandra;
import org.apache.cassandra.service.Column;
import org.apache.cassandra.service.ColumnOrSuperColumn;
import org.apache.cassandra.service.ColumnParent;
import org.apache.cassandra.service.ColumnPath;
import org.apache.cassandra.service.InvalidRequestException;
import org.apache.cassandra.service.NotFoundException;
import org.apache.cassandra.service.SlicePredicate;
import org.apache.cassandra.service.SliceRange;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.SuperColumn;
import org.apache.cassandra.service.ThriftValidation;
import org.apache.cassandra.service.UnavailableException;
import org.apache.cassandra.utils.LogUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class CassandraServer
implements Cassandra.Iface {
    public static String TOKEN_MAP = "token map";
    private static Logger logger = Logger.getLogger(CassandraServer.class);
    private static final List<ColumnOrSuperColumn> EMPTY_COLUMNS = Collections.emptyList();
    private static final List<Column> EMPTY_SUBCOLUMNS = Collections.emptyList();
    protected StorageService storageService = StorageService.instance();

    public void start() throws IOException {
        LogUtil.init();
        this.storageService.start();
    }

    protected Map<String, ColumnFamily> readColumnFamily(List<ReadCommand> commands, int consistency_level) throws InvalidRequestException, UnavailableException {
        List<Row> rows;
        String cfName = commands.get(0).getColumnFamilyName();
        HashMap<String, ColumnFamily> columnFamilyKeyMap = new HashMap<String, ColumnFamily>();
        for (ReadCommand command : commands) {
            ThriftValidation.validateKey(command.key);
        }
        if (consistency_level == 0) {
            throw new InvalidRequestException("Consistency level zero may not be applied to read operations");
        }
        if (consistency_level == 3) {
            throw new InvalidRequestException("Consistency level all is not yet supported on read operations");
        }
        try {
            rows = StorageProxy.readProtocol(commands, consistency_level);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        for (Row row : rows) {
            columnFamilyKeyMap.put(row.key(), row.getColumnFamily(cfName));
        }
        return columnFamilyKeyMap;
    }

    public List<Column> thriftifySubColumns(Collection<IColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY_SUBCOLUMNS;
        }
        ArrayList<Column> thriftColumns = new ArrayList<Column>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column thrift_column = new Column(column.name(), column.value(), column.timestamp());
            thriftColumns.add(thrift_column);
        }
        return thriftColumns;
    }

    public List<ColumnOrSuperColumn> thriftifyColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column thrift_column = new Column(column.name(), column.value(), column.timestamp());
            thriftColumns.add(new ColumnOrSuperColumn(thrift_column, null));
        }
        if (reverseOrder) {
            Collections.reverse(thriftColumns);
        }
        return thriftColumns;
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            List<Column> subcolumns = this.thriftifySubColumns(column.getSubColumns());
            if (subcolumns.isEmpty()) continue;
            SuperColumn superColumn = new SuperColumn(column.name(), subcolumns);
            thriftSuperColumns.add(new ColumnOrSuperColumn(null, superColumn));
        }
        if (reverseOrder) {
            Collections.reverse(thriftSuperColumns);
        }
        return thriftSuperColumns;
    }

    private Map<String, List<ColumnOrSuperColumn>> getSlice(List<ReadCommand> commands, int consistency_level) throws InvalidRequestException, UnavailableException {
        Map<String, ColumnFamily> cfamilies = this.readColumnFamily(commands, consistency_level);
        HashMap<String, List<ColumnOrSuperColumn>> columnFamiliesMap = new HashMap<String, List<ColumnOrSuperColumn>>();
        for (ReadCommand command : commands) {
            boolean reverseOrder;
            ColumnFamily cfamily = cfamilies.get(command.key);
            boolean bl = reverseOrder = command instanceof SliceFromReadCommand && ((SliceFromReadCommand)command).reversed;
            if (cfamily == null || cfamily.getColumnsMap().size() == 0) {
                columnFamiliesMap.put(command.key, EMPTY_COLUMNS);
                continue;
            }
            if (command.queryPath.superColumnName != null) {
                IColumn column = cfamily.getColumnsMap().values().iterator().next();
                Collection<IColumn> subcolumns = column.getSubColumns();
                if (subcolumns == null || subcolumns.isEmpty()) {
                    columnFamiliesMap.put(command.key, EMPTY_COLUMNS);
                    continue;
                }
                columnFamiliesMap.put(command.key, this.thriftifyColumns(subcolumns, reverseOrder));
                continue;
            }
            if (cfamily.isSuper()) {
                columnFamiliesMap.put(command.key, this.thriftifySuperColumns(cfamily.getSortedColumns(), reverseOrder));
                continue;
            }
            columnFamiliesMap.put(command.key, this.thriftifyColumns(cfamily.getSortedColumns(), reverseOrder));
        }
        return columnFamiliesMap;
    }

    @Override
    public List<ColumnOrSuperColumn> get_slice(String keyspace, String key, ColumnParent column_parent, SlicePredicate predicate, int consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get_slice");
        }
        return this.multigetSliceInternal(keyspace, Arrays.asList(key), column_parent, predicate, consistency_level).get(key);
    }

    @Override
    public Map<String, List<ColumnOrSuperColumn>> multiget_slice(String keyspace, List<String> keys, ColumnParent column_parent, SlicePredicate predicate, int consistency_level) throws InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"multiget_slice");
        }
        return this.multigetSliceInternal(keyspace, keys, column_parent, predicate, consistency_level);
    }

    private Map<String, List<ColumnOrSuperColumn>> multigetSliceInternal(String keyspace, List<String> keys, ColumnParent column_parent, SlicePredicate predicate, int consistency_level) throws InvalidRequestException, UnavailableException {
        ThriftValidation.validateColumnParent(keyspace, column_parent);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        SliceRange range = predicate.slice_range;
        if (predicate.column_names != null) {
            for (String key : keys) {
                commands.add(new SliceByNamesReadCommand(keyspace, key, column_parent, predicate.column_names));
            }
            ThriftValidation.validateColumns(keyspace, column_parent, predicate.column_names);
        } else {
            for (String key : keys) {
                commands.add(new SliceFromReadCommand(keyspace, key, column_parent, range.start, range.finish, range.reversed, range.count));
            }
            ThriftValidation.validateRange(keyspace, column_parent, range);
        }
        return this.getSlice(commands, consistency_level);
    }

    @Override
    public ColumnOrSuperColumn get(String table, String key, ColumnPath column_path, int consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException {
        ColumnOrSuperColumn column;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get");
        }
        if (!(column = this.multiget(table, Arrays.asList(key), column_path, consistency_level).get(key)).isSetColumn() && !column.isSetSuper_column()) {
            throw new NotFoundException();
        }
        return column;
    }

    private Map<String, Collection<IColumn>> multigetColumns(List<ReadCommand> commands, int consistency_level) throws InvalidRequestException, UnavailableException {
        Map<String, ColumnFamily> cfamilies = this.readColumnFamily(commands, consistency_level);
        HashMap<String, Collection<IColumn>> columnFamiliesMap = new HashMap<String, Collection<IColumn>>();
        for (ReadCommand command : commands) {
            ColumnFamily cfamily = cfamilies.get(command.key);
            if (cfamily == null) continue;
            Collection<IColumn> columns = null;
            if (command.queryPath.superColumnName != null) {
                IColumn column = cfamily.getColumn(command.queryPath.superColumnName);
                if (column != null) {
                    columns = column.getSubColumns();
                }
            } else {
                columns = cfamily.getSortedColumns();
            }
            if (columns == null || columns.size() == 0) continue;
            columnFamiliesMap.put(command.key, columns);
        }
        return columnFamiliesMap;
    }

    @Override
    public Map<String, ColumnOrSuperColumn> multiget(String table, List<String> keys, ColumnPath column_path, int consistency_level) throws InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"multiget");
        }
        return this.multigetInternal(table, keys, column_path, consistency_level);
    }

    private Map<String, ColumnOrSuperColumn> multigetInternal(String table, List<String> keys, ColumnPath column_path, int consistency_level) throws InvalidRequestException, UnavailableException {
        ThriftValidation.validateColumnPath(table, column_path);
        QueryPath path = new QueryPath(column_path.column_family, column_path.super_column);
        List<byte[]> nameAsList = Arrays.asList(new byte[][]{column_path.column == null ? column_path.super_column : column_path.column});
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        for (String key : keys) {
            commands.add(new SliceByNamesReadCommand(table, key, path, nameAsList));
        }
        HashMap<String, ColumnOrSuperColumn> columnFamiliesMap = new HashMap<String, ColumnOrSuperColumn>();
        Map<String, Collection<IColumn>> columnsMap = this.multigetColumns(commands, consistency_level);
        for (ReadCommand command : commands) {
            ColumnOrSuperColumn columnorsupercolumn;
            Collection<IColumn> columns = columnsMap.get(command.key);
            if (columns == null) {
                columnorsupercolumn = new ColumnOrSuperColumn();
            } else {
                assert (columns.size() == 1);
                IColumn column = columns.iterator().next();
                columnorsupercolumn = column.isMarkedForDelete() ? new ColumnOrSuperColumn() : (column instanceof org.apache.cassandra.db.Column ? new ColumnOrSuperColumn(new Column(column.name(), column.value(), column.timestamp()), null) : new ColumnOrSuperColumn(null, new SuperColumn(column.name(), this.thriftifySubColumns(column.getSubColumns()))));
            }
            columnFamiliesMap.put(command.key, columnorsupercolumn);
        }
        return columnFamiliesMap;
    }

    @Override
    public int get_count(String table, String key, ColumnParent column_parent, int consistency_level) throws InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get_count");
        }
        return this.multigetCountInternal(table, Arrays.asList(key), column_parent, consistency_level).get(key);
    }

    private Map<String, Integer> multigetCountInternal(String table, List<String> keys, ColumnParent column_parent, int consistency_level) throws InvalidRequestException, UnavailableException {
        String cfType = ThriftValidation.validateColumnFamily(table, column_parent.column_family);
        if (cfType.equals("Standard") && column_parent.super_column != null) {
            throw new InvalidRequestException("columnfamily alone is required for standard CF " + column_parent.column_family);
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        for (String key : keys) {
            commands.add(new SliceFromReadCommand(table, key, column_parent, ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.EMPTY_BYTE_ARRAY, true, Integer.MAX_VALUE));
        }
        HashMap<String, Integer> columnFamiliesMap = new HashMap<String, Integer>();
        Map<String, Collection<IColumn>> columnsMap = this.multigetColumns(commands, consistency_level);
        for (ReadCommand command : commands) {
            Collection<IColumn> columns = columnsMap.get(command.key);
            if (columns == null) {
                columnFamiliesMap.put(command.key, 0);
                continue;
            }
            columnFamiliesMap.put(command.key, columns.size());
        }
        return columnFamiliesMap;
    }

    @Override
    public void insert(String table, String key, ColumnPath column_path, byte[] value, long timestamp, int consistency_level) throws InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"insert");
        }
        ThriftValidation.validateKey(key);
        ThriftValidation.validateColumnPath(table, column_path);
        RowMutation rm = new RowMutation(table, key.trim());
        try {
            rm.add(new QueryPath(column_path), value, timestamp);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        this.doInsert(consistency_level, rm);
    }

    @Override
    public void batch_insert(String keyspace, String key, Map<String, List<ColumnOrSuperColumn>> cfmap, int consistency_level) throws InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"batch_insert");
        }
        for (String cfName : cfmap.keySet()) {
            for (ColumnOrSuperColumn cosc : cfmap.get(cfName)) {
                if (cosc.column != null) {
                    ThriftValidation.validateColumnPath(keyspace, new ColumnPath(cfName, null, cosc.column.name));
                }
                if (cosc.super_column == null) continue;
                for (Column c : cosc.super_column.columns) {
                    ThriftValidation.validateColumnPath(keyspace, new ColumnPath(cfName, cosc.super_column.name, c.name));
                }
            }
        }
        this.doInsert(consistency_level, RowMutation.getRowMutation(keyspace, key, cfmap));
    }

    @Override
    public void remove(String table, String key, ColumnPath column_path, long timestamp, int consistency_level) throws InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"remove");
        }
        ThriftValidation.validateColumnPathOrParent(table, column_path);
        RowMutation rm = new RowMutation(table, key.trim());
        rm.delete(new QueryPath(column_path), timestamp);
        this.doInsert(consistency_level, rm);
    }

    private void doInsert(int consistency_level, RowMutation rm) throws UnavailableException {
        if (consistency_level != 0) {
            StorageProxy.insertBlocking(rm, consistency_level);
        } else {
            StorageProxy.insert(rm);
        }
    }

    @Override
    public String get_string_property(String propertyName) {
        if (propertyName.equals("cluster name")) {
            return DatabaseDescriptor.getClusterName();
        }
        if (propertyName.equals("config file")) {
            String filename = DatabaseDescriptor.getConfigFileName();
            try {
                int numRead;
                StringBuilder fileData = new StringBuilder(8192);
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
                byte[] buf = new byte[1024];
                while ((numRead = stream.read(buf)) != -1) {
                    String str = new String(buf, 0, numRead);
                    fileData.append(str);
                }
                stream.close();
                return fileData.toString();
            }
            catch (IOException e) {
                return "file not found!";
            }
        }
        if (propertyName.equals(TOKEN_MAP)) {
            HashMap<String, String> tokenToHostMap = new HashMap<String, String>();
            Map<Token, EndPoint> endpointMap = this.storageService.getLiveEndPointMap();
            for (Map.Entry<Token, EndPoint> e : endpointMap.entrySet()) {
                tokenToHostMap.put(e.getKey().toString(), e.getValue().getHost());
            }
            return new JSONSerializer().serialize(tokenToHostMap);
        }
        if (propertyName.equals("version")) {
            return "0.4.1";
        }
        return "?";
    }

    @Override
    public List<String> get_string_list_property(String propertyName) {
        if (propertyName.equals("keyspaces")) {
            return DatabaseDescriptor.getTables();
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, Map<String, String>> describe_keyspace(String table) throws NotFoundException {
        HashMap<String, Map<String, String>> columnFamiliesMap = new HashMap<String, Map<String, String>>();
        Map<String, CFMetaData> tableMetaData = DatabaseDescriptor.getTableMetaData(table);
        if (tableMetaData == null) {
            throw new NotFoundException();
        }
        for (Map.Entry<String, CFMetaData> pairs : tableMetaData.entrySet()) {
            CFMetaData columnFamilyMetaData = pairs.getValue();
            String desc = "";
            HashMap<String, String> columnMap = new HashMap<String, String>();
            desc = columnFamilyMetaData.n_columnMap + "(" + columnFamilyMetaData.n_columnKey + ", " + columnFamilyMetaData.n_columnValue + ", " + columnFamilyMetaData.n_columnTimestamp + ")";
            if (columnFamilyMetaData.columnType.equals("Super")) {
                columnMap.put("Type", "Super");
                desc = columnFamilyMetaData.n_superColumnMap + "(" + columnFamilyMetaData.n_superColumnKey + ", " + desc + ")";
            } else {
                columnMap.put("Type", "Standard");
            }
            desc = columnFamilyMetaData.tableName + "." + columnFamilyMetaData.cfName + "(" + columnFamilyMetaData.n_rowKey + ", " + desc + ")";
            columnMap.put("Desc", desc);
            columnMap.put("CompareWith", columnFamilyMetaData.comparator.getClass().getName());
            if (columnFamilyMetaData.columnType.equals("Super")) {
                columnMap.put("CompareSubcolumnsWith", columnFamilyMetaData.subcolumnComparator.getClass().getName());
            }
            columnMap.put("FlushPeriodInMinutes", columnFamilyMetaData.flushPeriodInMinutes + "");
            columnFamiliesMap.put(columnFamilyMetaData.cfName, columnMap);
        }
        return columnFamiliesMap;
    }

    @Override
    public List<String> get_key_range(String tablename, String columnFamily, String startWith, String stopAt, int maxResults, int consistency_level) throws InvalidRequestException, TException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get_key_range");
        }
        ThriftValidation.validateCommand(tablename, columnFamily);
        if (!StorageService.getPartitioner().preservesOrder()) {
            throw new InvalidRequestException("range queries may only be performed against an order-preserving partitioner");
        }
        if (maxResults <= 0) {
            throw new InvalidRequestException("maxResults must be positive");
        }
        try {
            return StorageProxy.getKeyRange(new RangeCommand(tablename, columnFamily, startWith, stopAt, maxResults));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

