/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.RecoveryManager;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.service.Cassandra;
import org.apache.cassandra.service.CassandraServer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class CassandraDaemon {
    private static Logger logger = Logger.getLogger(CassandraDaemon.class);
    private TThreadPoolServer serverEngine;

    private void setup() throws IOException, TTransportException {
        TFramedTransport.Factory outTransportFactory;
        TFramedTransport.Factory inTransportFactory;
        int listenPort = DatabaseDescriptor.getThriftPort();
        String listenAddr = DatabaseDescriptor.getThriftAddress();
        if (listenAddr == null) {
            listenAddr = FBUtilities.getHostAddress();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error((Object)("Fatal exception in thread " + t), e);
                if (e instanceof OutOfMemoryError) {
                    System.exit(100);
                }
            }
        });
        Set<String> tables = DatabaseDescriptor.getTableToColumnFamilyMap().keySet();
        for (String table : tables) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("opening keyspace " + table));
            }
            Table tbl = Table.open(table);
            tbl.onStart();
        }
        RecoveryManager recoveryMgr = RecoveryManager.instance();
        recoveryMgr.doRecovery();
        CassandraServer peerStorageServer = new CassandraServer();
        peerStorageServer.start();
        Cassandra.Processor processor = new Cassandra.Processor(peerStorageServer);
        TServerSocket tServerSocket = new TServerSocket(new InetSocketAddress(listenAddr, listenPort));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
        }
        TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory();
        if (DatabaseDescriptor.isThriftFramed()) {
            inTransportFactory = new TFramedTransport.Factory();
            outTransportFactory = new TFramedTransport.Factory();
        } else {
            inTransportFactory = new TTransportFactory();
            outTransportFactory = new TTransportFactory();
        }
        TThreadPoolServer.Options options = new TThreadPoolServer.Options();
        options.minWorkerThreads = 64;
        this.serverEngine = new TThreadPoolServer(new TProcessorFactory((TProcessor)processor), (TServerTransport)tServerSocket, (TTransportFactory)inTransportFactory, (TTransportFactory)outTransportFactory, (TProtocolFactory)tProtocolFactory, (TProtocolFactory)tProtocolFactory, options);
    }

    public void init(String[] args) throws IOException, TTransportException {
        this.setup();
    }

    public void start() {
        logger.info((Object)"Cassandra starting up...");
        this.serverEngine.serve();
    }

    public void stop() {
        logger.info((Object)"Cassandra shutting down...");
        this.serverEngine.stop();
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        CassandraDaemon daemon = new CassandraDaemon();
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            daemon.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            daemon.start();
        }
        catch (Exception e) {
            String msg = "Exception encountered during startup.";
            logger.error((Object)msg, (Throwable)e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(3);
        }
    }
}

