/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.net.ProtocolHeader;
import org.apache.cassandra.net.TcpConnection;
import org.apache.cassandra.net.io.ContentLengthState;
import org.apache.cassandra.net.io.ContentState;
import org.apache.cassandra.net.io.ProtocolState;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.StartState;

public class TcpReader {
    private Map<TcpReaderState, StartState> stateMap_ = new HashMap<TcpReaderState, StartState>();
    private TcpConnection connection_;
    private StartState socketState_;
    private ProtocolHeader protocolHeader_;

    public TcpReader(TcpConnection connection) {
        this.connection_ = connection;
    }

    public StartState getSocketState(TcpReaderState state) {
        return this.stateMap_.get((Object)state);
    }

    public void putSocketState(TcpReaderState state, StartState socketState) {
        this.stateMap_.put(state, socketState);
    }

    public void resetState() {
        StartState nextState = this.stateMap_.get((Object)TcpReaderState.PREAMBLE);
        if (nextState == null) {
            nextState = new ProtocolState(this);
            this.stateMap_.put(TcpReaderState.PREAMBLE, nextState);
        }
        this.socketState_ = nextState;
    }

    public void morphState(StartState state) {
        this.socketState_ = state;
        if (this.protocolHeader_ == null) {
            this.protocolHeader_ = new ProtocolHeader();
        }
    }

    public ProtocolHeader getProtocolHeader() {
        return this.protocolHeader_;
    }

    public SocketChannel getStream() {
        return this.connection_.getSocketChannel();
    }

    public byte[] read() throws IOException {
        byte[] bytes = new byte[]{};
        while (this.socketState_ != null) {
            try {
                bytes = this.socketState_.read();
            }
            catch (ReadNotCompleteException e) {
                break;
            }
        }
        return bytes;
    }

    public static void main(String[] args) throws Throwable {
        HashMap<TcpReaderState, StartState> stateMap = new HashMap<TcpReaderState, StartState>();
        stateMap.put(TcpReaderState.CONTENT, new ContentState(null, 10));
        stateMap.put(TcpReaderState.START, new ProtocolState(null));
        stateMap.put(TcpReaderState.CONTENT_LENGTH, new ContentLengthState(null));
        StartState state = (StartState)stateMap.get((Object)TcpReaderState.CONTENT);
        System.out.println(state.getClass().getName());
        state = (StartState)stateMap.get((Object)TcpReaderState.CONTENT_LENGTH);
        System.out.println(state.getClass().getName());
    }

    public static enum TcpReaderState {
        START,
        PREAMBLE,
        PROTOCOL,
        CONTENT_LENGTH,
        CONTENT,
        CONTENT_STREAM,
        DONE;

    }
}

