/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.TcpReader;

public abstract class StartState {
    protected TcpReader stream_;

    public StartState(TcpReader stream) {
        this.stream_ = stream;
    }

    public abstract byte[] read() throws IOException, ReadNotCompleteException;

    public abstract void morphState() throws IOException;

    public abstract void setContextData(Object var1);

    protected byte[] doRead(ByteBuffer buffer) throws IOException, ReadNotCompleteException {
        SocketChannel socketChannel = this.stream_.getStream();
        int bytesRead = socketChannel.read(buffer);
        if (bytesRead == -1 && buffer.remaining() > 0) {
            throw new IOException("Reached an EOL or something bizzare occured. Reading from: " + socketChannel.socket().getInetAddress() + " BufferSizeRemaining: " + buffer.remaining());
        }
        if (buffer.remaining() != 0) {
            throw new ReadNotCompleteException("Specified number of bytes have not been read from the Socket Channel");
        }
        this.morphState();
        return new byte[0];
    }
}

