/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.io.ContentLengthState;
import org.apache.cassandra.net.io.ContentStreamState;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.StartState;
import org.apache.cassandra.net.io.TcpReader;

public class ProtocolHeaderState
extends StartState {
    private ByteBuffer buffer_ = ByteBuffer.allocate(4);

    public ProtocolHeaderState(TcpReader stream) {
        super(stream);
    }

    @Override
    public byte[] read() throws IOException, ReadNotCompleteException {
        return this.doRead(this.buffer_);
    }

    @Override
    public void morphState() throws IOException {
        int version;
        int type;
        byte[] protocolHeader = this.buffer_.array();
        int pH = MessagingService.byteArrayToInt(protocolHeader);
        this.stream_.getProtocolHeader().serializerType_ = type = MessagingService.getBits(pH, 1, 2);
        int stream = MessagingService.getBits(pH, 3, 1);
        boolean bl = this.stream_.getProtocolHeader().isStreamingMode_ = stream == 1;
        if (this.stream_.getProtocolHeader().isStreamingMode_) {
            MessagingService.setStreamingMode(true);
        }
        int listening = MessagingService.getBits(pH, 4, 1);
        this.stream_.getProtocolHeader().isListening_ = listening == 1;
        this.stream_.getProtocolHeader().version_ = version = MessagingService.getBits(pH, 15, 8);
        if (version <= MessagingService.getVersion()) {
            if (this.stream_.getProtocolHeader().isStreamingMode_) {
                StartState nextState = this.stream_.getSocketState(TcpReader.TcpReaderState.CONTENT_STREAM);
                if (nextState == null) {
                    nextState = new ContentStreamState(this.stream_);
                    this.stream_.putSocketState(TcpReader.TcpReaderState.CONTENT_STREAM, nextState);
                }
                this.stream_.morphState(nextState);
                this.buffer_.clear();
            } else {
                StartState nextState = this.stream_.getSocketState(TcpReader.TcpReaderState.CONTENT_LENGTH);
                if (nextState == null) {
                    nextState = new ContentLengthState(this.stream_);
                    this.stream_.putSocketState(TcpReader.TcpReaderState.CONTENT_LENGTH, nextState);
                }
                this.stream_.morphState(nextState);
                this.buffer_.clear();
            }
        } else {
            throw new IOException("Invalid version in message. Scram.");
        }
    }

    @Override
    public void setContextData(Object data) {
        throw new UnsupportedOperationException("This method is not supported in the ProtocolHeaderState");
    }
}

