/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.apache.cassandra.net.io.DoneState;
import org.apache.cassandra.net.io.IStreamComplete;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.StartState;
import org.apache.cassandra.net.io.StreamContextManager;
import org.apache.cassandra.net.io.TcpReader;
import org.apache.log4j.Logger;

class ContentStreamState
extends StartState {
    private static Logger logger_ = Logger.getLogger(ContentStreamState.class);
    private static long count_ = 0x4000000L;
    private static byte[] bytes_ = new byte[1];
    private long bytesRead_ = 0L;
    private FileChannel fc_;
    private StreamContextManager.StreamContext streamContext_;
    private StreamContextManager.StreamStatus streamStatus_;

    ContentStreamState(TcpReader stream) {
        super(stream);
        SocketChannel socketChannel = stream.getStream();
        InetSocketAddress remoteAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        String remoteHost = remoteAddress.getAddress().getHostAddress();
        this.streamContext_ = StreamContextManager.getStreamContext(remoteHost);
        this.streamStatus_ = StreamContextManager.getStreamStatus(remoteHost);
    }

    private void createFileChannel() throws IOException {
        if (this.fc_ == null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Creating file for " + this.streamContext_.getTargetFile()));
            }
            FileOutputStream fos = new FileOutputStream(this.streamContext_.getTargetFile(), true);
            this.fc_ = fos.getChannel();
        }
    }

    @Override
    public byte[] read() throws IOException, ReadNotCompleteException {
        SocketChannel socketChannel = this.stream_.getStream();
        InetSocketAddress remoteAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        String remoteHostIp = remoteAddress.getAddress().getHostAddress();
        this.createFileChannel();
        if (this.streamContext_ != null) {
            try {
                this.bytesRead_ += this.fc_.transferFrom(socketChannel, this.bytesRead_, count_);
                if (this.bytesRead_ != this.streamContext_.getExpectedBytes()) {
                    throw new ReadNotCompleteException("Specified number of bytes have not been read from the Socket Channel");
                }
            }
            catch (IOException ex) {
                this.streamStatus_.setAction(StreamContextManager.StreamCompletionAction.STREAM);
                this.handleStreamCompletion(remoteHostIp);
                File file = new File(this.streamContext_.getTargetFile());
                file.delete();
                throw ex;
            }
            if (this.bytesRead_ == this.streamContext_.getExpectedBytes()) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Removing stream context " + this.streamContext_));
                }
                this.handleStreamCompletion(remoteHostIp);
                this.bytesRead_ = 0L;
                this.fc_.close();
                this.morphState();
            }
        }
        return new byte[0];
    }

    private void handleStreamCompletion(String remoteHost) throws IOException {
        IStreamComplete streamComplete = StreamContextManager.getStreamCompletionHandler(remoteHost);
        if (streamComplete != null) {
            streamComplete.onStreamCompletion(remoteHost, this.streamContext_, this.streamStatus_);
        }
    }

    @Override
    public void morphState() throws IOException {
        StartState nextState = this.stream_.getSocketState(TcpReader.TcpReaderState.DONE);
        if (nextState == null) {
            nextState = new DoneState(this.stream_, bytes_);
            this.stream_.putSocketState(TcpReader.TcpReaderState.DONE, nextState);
        } else {
            nextState.setContextData(bytes_);
        }
        this.stream_.morphState(nextState);
    }

    @Override
    public void setContextData(Object data) {
        throw new UnsupportedOperationException("This method is not supported in the ContentStreamState");
    }
}

