/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.net.io.DoneState;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.StartState;
import org.apache.cassandra.net.io.TcpReader;

class ContentState
extends StartState {
    private ByteBuffer buffer_;
    private int length_;

    ContentState(TcpReader stream, int length) {
        super(stream);
        this.length_ = length;
        this.buffer_ = ByteBuffer.allocate(this.length_);
    }

    @Override
    public byte[] read() throws IOException, ReadNotCompleteException {
        return this.doRead(this.buffer_);
    }

    @Override
    public void morphState() throws IOException {
        StartState nextState = this.stream_.getSocketState(TcpReader.TcpReaderState.DONE);
        if (nextState == null) {
            nextState = new DoneState(this.stream_, this.toBytes());
            this.stream_.putSocketState(TcpReader.TcpReaderState.DONE, nextState);
        } else {
            nextState.setContextData(this.toBytes());
        }
        this.stream_.morphState(nextState);
    }

    private byte[] toBytes() {
        this.buffer_.position(0);
        byte[] bytes = new byte[this.length_];
        this.buffer_.get(bytes, 0, this.length_);
        return bytes;
    }

    @Override
    public void setContextData(Object data) {
        Integer value = (Integer)data;
        this.length_ = value;
        this.buffer_.clear();
        if (this.buffer_.capacity() < this.length_) {
            this.buffer_ = ByteBuffer.allocate(this.length_);
        } else {
            this.buffer_.limit(this.length_);
        }
    }
}

