/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.net.io.ContentState;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.StartState;
import org.apache.cassandra.net.io.TcpReader;
import org.apache.cassandra.utils.FBUtilities;

class ContentLengthState
extends StartState {
    private ByteBuffer buffer_ = ByteBuffer.allocate(4);

    ContentLengthState(TcpReader stream) {
        super(stream);
    }

    @Override
    public byte[] read() throws IOException, ReadNotCompleteException {
        return this.doRead(this.buffer_);
    }

    @Override
    public void morphState() throws IOException {
        int size = FBUtilities.byteArrayToInt(this.buffer_.array());
        StartState nextState = this.stream_.getSocketState(TcpReader.TcpReaderState.CONTENT);
        if (nextState == null) {
            nextState = new ContentState(this.stream_, size);
            this.stream_.putSocketState(TcpReader.TcpReaderState.CONTENT, nextState);
        } else {
            nextState.setContextData(size);
        }
        this.stream_.morphState(nextState);
        this.buffer_.clear();
    }

    @Override
    public void setContextData(Object data) {
        throw new UnsupportedOperationException("This method is not supported in the ContentLengthState");
    }
}

