/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.log4j.Logger;

class ResponseVerbHandler
implements IVerbHandler {
    private static final Logger logger_ = Logger.getLogger(ResponseVerbHandler.class);

    ResponseVerbHandler() {
    }

    @Override
    public void doVerb(Message message) {
        String messageId = message.getMessageId();
        IAsyncCallback cb = MessagingService.getRegisteredCallback(messageId);
        if (cb != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Processing response on a callback from " + message.getMessageId() + "@" + message.getFrom()));
            }
            cb.response(message);
        } else {
            IAsyncResult ar = MessagingService.getAsyncResult(messageId);
            if (ar != null) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Processing response on an async result from " + message.getMessageId() + "@" + message.getFrom()));
                }
                ar.result(message);
            }
        }
    }
}

