/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

class AsyncResult
implements IAsyncResult {
    private static Logger logger_ = Logger.getLogger(AsyncResult.class);
    private byte[] result_;
    private AtomicBoolean done_ = new AtomicBoolean(false);
    private Lock lock_ = new ReentrantLock();
    private Condition condition_ = this.lock_.newCondition();
    private long startTime_ = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get() {
        this.lock_.lock();
        try {
            if (!this.done_.get()) {
                this.condition_.await();
            }
        }
        catch (InterruptedException ex) {
            logger_.warn((Object)LogUtil.throwableToString(ex));
        }
        finally {
            this.lock_.unlock();
        }
        return this.result_;
    }

    @Override
    public boolean isDone() {
        return this.done_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long timeout, TimeUnit tu) throws TimeoutException {
        this.lock_.lock();
        try {
            boolean bVal = true;
            try {
                if (!this.done_.get()) {
                    long overall_timeout = System.currentTimeMillis() - this.startTime_ + timeout;
                    bVal = overall_timeout > 0L ? this.condition_.await(overall_timeout, TimeUnit.MILLISECONDS) : false;
                }
            }
            catch (InterruptedException ex) {
                logger_.warn((Object)LogUtil.throwableToString(ex));
            }
            if (!bVal && !this.done_.get()) {
                throw new TimeoutException("Operation timed out.");
            }
        }
        finally {
            this.lock_.unlock();
        }
        return this.result_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void result(Message response) {
        try {
            this.lock_.lock();
            if (!this.done_.get()) {
                this.result_ = response.getMessageBody();
                this.done_.set(true);
                this.condition_.signal();
            }
        }
        finally {
            this.lock_.unlock();
        }
    }
}

