/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.UnavailableException;

public class TokenMetadata {
    private Map<Token, EndPoint> tokenToEndPointMap_;
    private Map<EndPoint, Token> endPointToTokenMap_;
    private Map<Token, EndPoint> bootstrapNodes;
    private final ReadWriteLock lock_ = new ReentrantReadWriteLock(true);

    public TokenMetadata() {
        this.tokenToEndPointMap_ = new HashMap<Token, EndPoint>();
        this.endPointToTokenMap_ = new HashMap<EndPoint, Token>();
        this.bootstrapNodes = Collections.synchronizedMap(new HashMap());
    }

    public TokenMetadata(Map<Token, EndPoint> tokenToEndPointMap, Map<EndPoint, Token> endPointToTokenMap, Map<Token, EndPoint> bootstrapNodes) {
        this.tokenToEndPointMap_ = tokenToEndPointMap;
        this.endPointToTokenMap_ = endPointToTokenMap;
        this.bootstrapNodes = bootstrapNodes;
    }

    public TokenMetadata cloneMe() {
        return new TokenMetadata(this.cloneTokenEndPointMap(), this.cloneEndPointTokenMap(), this.cloneBootstrapNodes());
    }

    public void update(Token token, EndPoint endpoint) {
        this.update(token, endpoint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Token token, EndPoint endpoint, boolean bootstrapState) {
        this.lock_.writeLock().lock();
        try {
            if (bootstrapState) {
                this.bootstrapNodes.put(token, endpoint);
                this.remove(endpoint);
            } else {
                this.bootstrapNodes.remove(token);
                Token oldToken = this.endPointToTokenMap_.get(endpoint);
                if (oldToken != null) {
                    this.tokenToEndPointMap_.remove(oldToken);
                }
                this.tokenToEndPointMap_.put(token, endpoint);
                this.endPointToTokenMap_.put(endpoint, token);
            }
        }
        finally {
            this.lock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EndPoint endpoint) {
        this.lock_.writeLock().lock();
        try {
            Token oldToken = this.endPointToTokenMap_.get(endpoint);
            if (oldToken != null) {
                this.tokenToEndPointMap_.remove(oldToken);
            }
            this.endPointToTokenMap_.remove(endpoint);
        }
        finally {
            this.lock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(EndPoint endpoint) {
        this.lock_.readLock().lock();
        try {
            Token token = this.endPointToTokenMap_.get(endpoint);
            return token;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnownEndPoint(EndPoint ep) {
        this.lock_.readLock().lock();
        try {
            boolean bl = this.endPointToTokenMap_.containsKey(ep);
            return bl;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint getFirstEndpoint() {
        this.lock_.readLock().lock();
        try {
            ArrayList<Token> tokens = new ArrayList<Token>(this.tokenToEndPointMap_.keySet());
            if (tokens.isEmpty()) {
                EndPoint endPoint = null;
                return endPoint;
            }
            Collections.sort(tokens);
            EndPoint endPoint = this.tokenToEndPointMap_.get(tokens.get(0));
            return endPoint;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint getNextEndpoint(EndPoint endPoint) throws UnavailableException {
        this.lock_.readLock().lock();
        try {
            EndPoint ep;
            block6: {
                ArrayList<Token> tokens = new ArrayList<Token>(this.tokenToEndPointMap_.keySet());
                if (tokens.isEmpty()) {
                    EndPoint endPoint2 = null;
                    return endPoint2;
                }
                Collections.sort(tokens);
                int i = tokens.indexOf(this.endPointToTokenMap_.get(endPoint));
                int j = 1;
                do {
                    ep = this.tokenToEndPointMap_.get(tokens.get((i + j) % tokens.size()));
                    if (FailureDetector.instance().isAlive(ep)) break block6;
                } while (++j <= DatabaseDescriptor.getReplicationFactor());
                throw new UnavailableException();
            }
            EndPoint endPoint3 = ep;
            return endPoint3;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Token, EndPoint> cloneBootstrapNodes() {
        this.lock_.readLock().lock();
        try {
            HashMap<Token, EndPoint> hashMap = new HashMap<Token, EndPoint>(this.bootstrapNodes);
            return hashMap;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Token, EndPoint> cloneTokenEndPointMap() {
        this.lock_.readLock().lock();
        try {
            HashMap<Token, EndPoint> hashMap = new HashMap<Token, EndPoint>(this.tokenToEndPointMap_);
            return hashMap;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EndPoint, Token> cloneEndPointTokenMap() {
        this.lock_.readLock().lock();
        try {
            HashMap<EndPoint, Token> hashMap = new HashMap<EndPoint, Token>(this.endPointToTokenMap_);
            return hashMap;
        }
        finally {
            this.lock_.readLock().unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<EndPoint> eps = this.endPointToTokenMap_.keySet();
        for (EndPoint ep : eps) {
            sb.append(ep);
            sb.append(":");
            sb.append(this.endPointToTokenMap_.get(ep));
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }
}

