/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.IndexHelper;
import org.apache.cassandra.io.SSTableReader;

public class IteratingRow
extends AbstractIterator<IColumn> {
    private final String key;
    private final long finishedAt;
    private final ColumnFamily emptyColumnFamily;
    private final BufferedRandomAccessFile file;

    public IteratingRow(BufferedRandomAccessFile file, SSTableReader sstable) throws IOException {
        this.file = file;
        this.key = file.readUTF();
        long dataSize = file.readInt();
        long dataStart = file.getFilePointer();
        this.finishedAt = dataStart + dataSize;
        IndexHelper.skipBloomFilterAndIndex(file);
        this.emptyColumnFamily = ColumnFamily.serializer().deserializeFromSSTableNoColumns(sstable.makeColumnFamily(), file);
        file.readInt();
    }

    public String getKey() {
        return this.key;
    }

    public ColumnFamily getEmptyColumnFamily() {
        return this.emptyColumnFamily;
    }

    public void skipRemaining() throws IOException {
        this.file.seek(this.finishedAt);
    }

    protected IColumn computeNext() {
        try {
            assert (this.file.getFilePointer() <= this.finishedAt);
            if (this.file.getFilePointer() == this.finishedAt) {
                return (IColumn)this.endOfData();
            }
            return this.emptyColumnFamily.getColumnSerializer().deserialize(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

