/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.BootstrapSourceTarget;
import org.apache.cassandra.dht.LeaveJoinProtocolHelper;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class LeaveJoinProtocolImpl
implements Runnable {
    private static Logger logger_ = Logger.getLogger(LeaveJoinProtocolImpl.class);
    protected EndPoint[] targets_ = new EndPoint[0];
    protected final Token[] tokens_;
    protected TokenMetadata tokenMetadata_ = null;

    public LeaveJoinProtocolImpl(EndPoint[] targets, Token[] tokens) {
        this.targets_ = targets;
        this.tokens_ = tokens;
        this.tokenMetadata_ = StorageService.instance().getTokenMetadata();
    }

    @Override
    public void run() {
        try {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Beginning leave/join process for ...");
            }
            Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
            Map<EndPoint, Token> endpointToTokenMap = this.tokenMetadata_.cloneEndPointTokenMap();
            HashSet<Token> oldTokens = new HashSet<Token>(tokenToEndPointMap.keySet());
            Range[] oldRanges = StorageService.instance().getAllRanges(oldTokens);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Total number of old ranges " + oldRanges.length));
            }
            Map<Range, List<EndPoint>> oldRangeToEndPointMap = StorageService.instance().constructRangeToEndPointMap(oldRanges);
            Set<Token> tokens = this.getTokensForLeavingNodes();
            oldTokens.removeAll(tokens);
            Range[] rangesAfterNodesLeave = StorageService.instance().getAllRanges(oldTokens);
            Map<Range, List<Range>> expandedRangeToOldRangeMap = LeaveJoinProtocolImpl.getExpandedRangeToOldRangeMapping(oldRanges, rangesAfterNodesLeave);
            for (Token token : this.tokens_) {
                oldTokens.add(token);
            }
            Range[] rangesAfterNodesJoin = StorageService.instance().getAllRanges(oldTokens);
            this.addSplitRangesToOldConfiguration(oldRangeToEndPointMap, rangesAfterNodesJoin);
            Range[] newRanges = StorageService.instance().getAllRanges(oldTokens);
            for (int i = 0; i < this.targets_.length; ++i) {
                tokenToEndPointMap.remove(endpointToTokenMap.get(this.targets_[i]));
                tokenToEndPointMap.put(this.tokens_[i], this.targets_[i]);
            }
            Map<Range, List<EndPoint>> newRangeToEndPointMap = StorageService.instance().constructRangeToEndPointMap(newRanges, tokenToEndPointMap);
            this.removeExpandedRangesFromNewConfiguration(newRangeToEndPointMap, expandedRangeToOldRangeMap);
            Map<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget = LeaveJoinProtocolHelper.getRangeSourceTargetInfo(oldRangeToEndPointMap, newRangeToEndPointMap);
            Set<Range> ranges = rangesWithSourceTarget.keySet();
            for (Range range : ranges) {
                System.out.print("RANGE: " + range + ":: ");
                List<BootstrapSourceTarget> infos = rangesWithSourceTarget.get(range);
                for (BootstrapSourceTarget info : infos) {
                    System.out.print(info);
                    System.out.print(" ");
                }
                System.out.println(System.getProperty("line.separator"));
            }
            LeaveJoinProtocolHelper.assignWork(rangesWithSourceTarget);
        }
        catch (Throwable th) {
            logger_.warn((Object)LogUtil.throwableToString(th));
        }
    }

    private void addSplitRangesToOldConfiguration(Map<Range, List<EndPoint>> oldRangeToEndPointMap, Range[] rangesAfterNodesJoin) {
        Map<Range, List<Range>> splitRanges = LeaveJoinProtocolHelper.getRangeSplitRangeMapping(oldRangeToEndPointMap.keySet().toArray(new Range[0]), this.tokens_);
        HashMap<Range, List<EndPoint>> replicasForSplitRanges = new HashMap<Range, List<EndPoint>>();
        Set<Range> rangesSplit = splitRanges.keySet();
        for (Range splitRange : rangesSplit) {
            replicasForSplitRanges.put(splitRange, oldRangeToEndPointMap.get(splitRange));
        }
        for (Range splitRange : rangesSplit) {
            oldRangeToEndPointMap.remove(splitRange);
        }
        for (Range splitRange : rangesSplit) {
            List<Range> subRanges = splitRanges.get(splitRange);
            List replicas = (List)replicasForSplitRanges.get(splitRange);
            for (Range subRange : subRanges) {
                oldRangeToEndPointMap.put(subRange, new ArrayList(replicas));
            }
        }
    }

    private void removeExpandedRangesFromNewConfiguration(Map<Range, List<EndPoint>> newRangeToEndPointMap, Map<Range, List<Range>> expandedRangeToOldRangeMap) {
        HashMap<Range, List<EndPoint>> replicasForExpandedRanges = new HashMap<Range, List<EndPoint>>();
        Set<Range> expandedRanges = expandedRangeToOldRangeMap.keySet();
        for (Range expandedRange : expandedRanges) {
            replicasForExpandedRanges.put(expandedRange, newRangeToEndPointMap.get(expandedRange));
            newRangeToEndPointMap.remove(expandedRange);
        }
        for (Range expandedRange : expandedRanges) {
            List<Range> subRanges = expandedRangeToOldRangeMap.get(expandedRange);
            List replicas = (List)replicasForExpandedRanges.get(expandedRange);
            for (Range subRange : subRanges) {
                newRangeToEndPointMap.put(subRange, new ArrayList(replicas));
            }
        }
    }

    private Set<Token> getTokensForLeavingNodes() {
        HashSet<Token> tokens = new HashSet<Token>();
        for (EndPoint target : this.targets_) {
            tokens.add(this.tokenMetadata_.getToken(target));
        }
        return tokens;
    }

    protected static Map<Range, List<Range>> getExpandedRangeToOldRangeMapping(Range[] oldRanges, Range[] newRanges) {
        HashMap<Range, List<Range>> map = new HashMap<Range, List<Range>>();
        ArrayList oRanges = new ArrayList();
        Collections.addAll(oRanges, oldRanges);
        ArrayList nRanges = new ArrayList();
        Collections.addAll(nRanges, newRanges);
        for (Range oRange : oldRanges) {
            boolean bVal = nRanges.remove(oRange);
            if (!bVal) continue;
            oRanges.remove(oRange);
        }
        int nSize = nRanges.size();
        int oSize = oRanges.size();
        for (int i = 0; i < nSize; ++i) {
            Range nRange = (Range)nRanges.get(i);
            for (int j = 0; j < oSize; ++j) {
                Range oRange = (Range)oRanges.get(j);
                if (!nRange.contains(oRange.right())) continue;
                ArrayList<Range> smallerRanges = (ArrayList<Range>)map.get(nRange);
                if (smallerRanges == null) {
                    smallerRanges = new ArrayList<Range>();
                    map.put(nRange, smallerRanges);
                }
                smallerRanges.add(oRange);
            }
        }
        return map;
    }

    public static void main(String[] args) throws Throwable {
        StorageService ss = StorageService.instance();
        ss.updateTokenMetadata(new BigIntegerToken("3"), new EndPoint("A", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("6"), new EndPoint("B", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("9"), new EndPoint("C", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("12"), new EndPoint("D", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("15"), new EndPoint("E", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("18"), new EndPoint("F", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("21"), new EndPoint("G", 7000));
        ss.updateTokenMetadata(new BigIntegerToken("24"), new EndPoint("H", 7000));
        LeaveJoinProtocolImpl runnable = new LeaveJoinProtocolImpl(new EndPoint[]{new EndPoint("C", 7000), new EndPoint("D", 7000)}, new Token[]{new BigIntegerToken("22"), new BigIntegerToken("23")});
        runnable.run();
    }
}

