/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Random;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FBUtilities;

public class CollatingOrderPreservingPartitioner
implements IPartitioner<BytesToken> {
    static final Collator collator = Collator.getInstance(new Locale("en", "US"));
    public static final BytesToken MINIMUM = new BytesToken(new byte[0]);
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return collator.compare(o1, o2);
        }
    };
    private static final Comparator<String> reverseComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return -comparator.compare(o1, o2);
        }
    };
    private final Token.TokenFactory<byte[]> tokenFactory = new Token.TokenFactory<byte[]>(){

        @Override
        public byte[] toByteArray(Token<byte[]> bytesToken) {
            return (byte[])bytesToken.token;
        }

        @Override
        public Token<byte[]> fromByteArray(byte[] bytes) {
            return new BytesToken(bytes);
        }

        @Override
        public String toString(Token<byte[]> bytesToken) {
            return FBUtilities.bytesToHex((byte[])bytesToken.token);
        }

        @Override
        public Token<byte[]> fromString(String string) {
            return new BytesToken(FBUtilities.hexToBytes(string));
        }
    };

    @Override
    public String decorateKey(String key) {
        return key;
    }

    @Override
    public String undecorateKey(String decoratedKey) {
        return decoratedKey;
    }

    @Override
    public Comparator<String> getDecoratedKeyComparator() {
        return comparator;
    }

    @Override
    public Comparator<String> getReverseDecoratedKeyComparator() {
        return reverseComparator;
    }

    private static byte[] midpoint(byte[] lbytes, byte[] rbytes) {
        int i;
        int inlength;
        int comparison = FBUtilities.compareByteArrays(lbytes, rbytes);
        if (comparison < 0) {
            inlength = Math.max(lbytes.length, rbytes.length);
            if (lbytes.length < inlength) {
                lbytes = Arrays.copyOf(lbytes, inlength);
            } else if (rbytes.length < inlength) {
                rbytes = Arrays.copyOf(rbytes, inlength);
            }
        } else {
            assert (FBUtilities.isEqualBits((byte[])CollatingOrderPreservingPartitioner.MINIMUM.token, rbytes));
            inlength = Math.max(lbytes.length, 1);
            if (lbytes.length < inlength) {
                lbytes = Arrays.copyOf(lbytes, inlength);
            }
            rbytes = new byte[inlength];
            Arrays.fill(rbytes, (byte)-1);
        }
        int outlength = (lbytes[inlength - 1] & 1) == (rbytes[inlength - 1] & 1) ? inlength : inlength + 1;
        byte[] result = new byte[outlength];
        boolean carrying = false;
        for (i = inlength - 1; i >= 0; --i) {
            int sum = carrying ? 1 : 0;
            carrying = (sum += (lbytes[i] & 0xFF) + (rbytes[i] & 0xFF)) > 255;
            result[i] = (byte)sum;
        }
        for (i = 0; i < inlength; ++i) {
            byte shifted = (byte)(carrying ? 128 : 0);
            carrying = (result[i] & 1) == 1;
            result[i] = (byte)(shifted | (result[i] & 0xFF) >>> 1);
        }
        if (carrying) {
            int n = inlength;
            result[n] = (byte)(result[n] | 0x80);
        }
        return result;
    }

    @Override
    public BytesToken midpoint(BytesToken ltoken, BytesToken rtoken) {
        return new BytesToken(CollatingOrderPreservingPartitioner.midpoint((byte[])ltoken.token, (byte[])rtoken.token));
    }

    @Override
    public BytesToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BytesToken getDefaultToken() {
        String initialToken = DatabaseDescriptor.getInitialToken();
        if (initialToken != null) {
            return this.getToken(initialToken);
        }
        Random r = new Random();
        byte[] buffer = new byte[16];
        r.nextBytes(buffer);
        return new BytesToken(buffer);
    }

    @Override
    public Token.TokenFactory<byte[]> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public BytesToken getToken(String key) {
        return new BytesToken(collator.getCollationKey(key).toByteArray());
    }
}

