/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cassandra.dht.BootstrapMetadata;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.CompactEndPointSerializationHelper;
import org.apache.cassandra.net.EndPoint;

class BootstrapMetadataSerializer
implements ICompactSerializer<BootstrapMetadata> {
    BootstrapMetadataSerializer() {
    }

    @Override
    public void serialize(BootstrapMetadata bsMetadata, DataOutputStream dos) throws IOException {
        CompactEndPointSerializationHelper.serialize(bsMetadata.target_, dos);
        dos.writeInt(bsMetadata.ranges_.size());
        for (Range range : bsMetadata.ranges_) {
            Range.serializer().serialize(range, dos);
        }
    }

    @Override
    public BootstrapMetadata deserialize(DataInputStream dis) throws IOException {
        EndPoint target = CompactEndPointSerializationHelper.deserialize(dis);
        int size = dis.readInt();
        ArrayList<Range> ranges = size == 0 ? null : new ArrayList<Range>();
        for (int i = 0; i < size; ++i) {
            ranges.add(Range.serializer().deserialize(dis));
        }
        return new BootstrapMetadata(target, ranges);
    }
}

