/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.BootstrapSourceTarget;
import org.apache.cassandra.dht.LeaveJoinProtocolHelper;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class BootStrapper
implements Runnable {
    private static Logger logger_ = Logger.getLogger(BootStrapper.class);
    private static final long INITIAL_DELAY = 60000L;
    protected EndPoint[] targets_ = new EndPoint[0];
    protected final Token[] tokens_;
    protected TokenMetadata tokenMetadata_ = null;

    public BootStrapper(EndPoint[] target, Token ... token) {
        this.targets_ = target;
        this.tokens_ = token;
        this.tokenMetadata_ = StorageService.instance().getTokenMetadata();
    }

    @Override
    public void run() {
        block4: {
            try {
                Thread.sleep(60000L);
                this.tokenMetadata_ = StorageService.instance().getTokenMetadata();
                for (int i = 0; i < this.targets_.length; ++i) {
                    this.tokenMetadata_.update(this.tokens_[i], this.targets_[i], false);
                }
                Map<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget = this.getRangesWithSourceTarget();
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Beginning bootstrap process for " + Arrays.toString(this.targets_) + " ..."));
                }
                LeaveJoinProtocolHelper.assignWork(rangesWithSourceTarget);
            }
            catch (Throwable th) {
                if (!logger_.isDebugEnabled()) break block4;
                logger_.debug((Object)LogUtil.throwableToString(th));
            }
        }
    }

    Map<Range, List<BootstrapSourceTarget>> getRangesWithSourceTarget() {
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        for (Token token : this.tokens_) {
            tokenToEndPointMap.remove(token);
        }
        HashSet<Token> oldTokens = new HashSet<Token>(tokenToEndPointMap.keySet());
        Range[] oldRanges = StorageService.instance().getAllRanges(oldTokens);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Total number of old ranges " + oldRanges.length));
        }
        Map<Range, List<Range>> splitRanges = LeaveJoinProtocolHelper.getRangeSplitRangeMapping(oldRanges, this.tokens_);
        Map<Range, List<EndPoint>> oldRangeToEndPointMap = StorageService.instance().constructRangeToEndPointMap(oldRanges, tokenToEndPointMap);
        HashMap<Range, List<EndPoint>> replicasForSplitRanges = new HashMap<Range, List<EndPoint>>();
        Set<Range> rangesSplit = splitRanges.keySet();
        for (Range splitRange : rangesSplit) {
            replicasForSplitRanges.put(splitRange, oldRangeToEndPointMap.get(splitRange));
        }
        for (Range splitRange : rangesSplit) {
            oldRangeToEndPointMap.remove(splitRange);
        }
        for (Range splitRange : rangesSplit) {
            List<Range> subRanges = splitRanges.get(splitRange);
            List replicas = (List)replicasForSplitRanges.get(splitRange);
            for (Range subRange : subRanges) {
                oldRangeToEndPointMap.put(subRange, new ArrayList(replicas));
            }
        }
        Collections.addAll(oldTokens, this.tokens_);
        Range[] newRanges = StorageService.instance().getAllRanges(oldTokens);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Total number of new ranges " + newRanges.length));
        }
        Map<Range, List<EndPoint>> newRangeToEndPointMap = StorageService.instance().constructRangeToEndPointMap(newRanges);
        Map<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget = LeaveJoinProtocolHelper.getRangeSourceTargetInfo(oldRangeToEndPointMap, newRangeToEndPointMap);
        return rangesWithSourceTarget;
    }
}

