/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadCommandSerializer;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.filter.QueryPath;

class SliceByNamesReadCommandSerializer
extends ReadCommandSerializer {
    SliceByNamesReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutputStream dos) throws IOException {
        SliceByNamesReadCommand realRM = (SliceByNamesReadCommand)rm;
        dos.writeBoolean(realRM.isDigestQuery());
        dos.writeUTF(realRM.table);
        dos.writeUTF(realRM.key);
        realRM.queryPath.serialize(dos);
        dos.writeInt(realRM.columnNames.size());
        if (realRM.columnNames.size() > 0) {
            for (byte[] cName : realRM.columnNames) {
                ColumnSerializer.writeName(cName, dos);
            }
        }
    }

    @Override
    public ReadCommand deserialize(DataInputStream dis) throws IOException {
        boolean isDigest = dis.readBoolean();
        String table = dis.readUTF();
        String key = dis.readUTF();
        QueryPath columnParent = QueryPath.deserialize(dis);
        int size = dis.readInt();
        ArrayList<byte[]> columns = new ArrayList<byte[]>();
        for (int i = 0; i < size; ++i) {
            columns.add(ColumnSerializer.readName(dis));
        }
        SliceByNamesReadCommand rm = new SliceByNamesReadCommand(table, key, columnParent, columns);
        rm.setDigestQuery(isDigest);
        return rm;
    }
}

