/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IScanner;
import org.apache.cassandra.db.Table;

public class Scanner
implements IScanner<IColumn> {
    private String table_;
    private Iterator<IColumn> columnIt_;

    public Scanner(String table) {
        this.table_ = table;
    }

    @Override
    public void fetch(String key, String cf) throws IOException {
        Table table;
        ColumnFamily columnFamily;
        if (cf != null && (columnFamily = (table = Table.open(this.table_)).get(key, cf)) != null) {
            Collection<IColumn> columns = columnFamily.getSortedColumns();
            this.columnIt_ = columns.iterator();
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.columnIt_.hasNext();
    }

    @Override
    public IColumn next() {
        return this.columnIt_.next();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("This operation is not supported in the Scanner");
    }
}

