/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowMutationMessageSerializer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class RowMutationMessage
implements Serializable {
    public static final String hint_ = "HINT";
    private static RowMutationMessageSerializer serializer_ = new RowMutationMessageSerializer();
    @XmlElement(name="RowMutation")
    private RowMutation rowMutation_;

    static RowMutationMessageSerializer serializer() {
        return serializer_;
    }

    public Message makeRowMutationMessage() throws IOException {
        return this.makeRowMutationMessage("ROW-MUTATION-VERB-HANDLER");
    }

    public Message makeRowMutationMessage(String verbHandlerName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        RowMutationMessage.serializer().serialize(this, dos);
        EndPoint local = StorageService.getLocalStorageEndPoint();
        EndPoint from = local != null ? local : new EndPoint(FBUtilities.getHostAddress(), 7000);
        return new Message(from, "ROW-MUTATION-STAGE", verbHandlerName, bos.toByteArray());
    }

    private RowMutationMessage() {
    }

    public RowMutationMessage(RowMutation rowMutation) {
        this.rowMutation_ = rowMutation;
    }

    public RowMutation getRowMutation() {
        return this.rowMutation_;
    }
}

