/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommandSerializer;
import org.apache.cassandra.db.SliceFromReadCommandSerializer;
import org.apache.cassandra.io.ICompactSerializer;

class ReadCommandSerializer
implements ICompactSerializer<ReadCommand> {
    private static final Map<Byte, ReadCommandSerializer> CMD_SERIALIZER_MAP = new HashMap<Byte, ReadCommandSerializer>();

    ReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutputStream dos) throws IOException {
        dos.writeByte(rm.commandType);
        ReadCommandSerializer ser = CMD_SERIALIZER_MAP.get(rm.commandType);
        ser.serialize(rm, dos);
    }

    @Override
    public ReadCommand deserialize(DataInputStream dis) throws IOException {
        byte msgType = dis.readByte();
        return CMD_SERIALIZER_MAP.get(msgType).deserialize(dis);
    }

    static {
        CMD_SERIALIZER_MAP.put((byte)1, new SliceByNamesReadCommandSerializer());
        CMD_SERIALIZER_MAP.put((byte)2, new SliceFromReadCommandSerializer());
    }
}

