/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.ThreadFactoryImpl;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.log4j.Logger;

class PeriodicFlushManager {
    private static Logger logger_ = Logger.getLogger(PeriodicFlushManager.class);
    private static PeriodicFlushManager instance_;
    private static Lock lock_;
    private ScheduledExecutorService flusher_ = new DebuggableScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("PERIODIC-FLUSHER-POOL"));

    PeriodicFlushManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeriodicFlushManager instance() {
        if (instance_ == null) {
            lock_.lock();
            try {
                if (instance_ == null) {
                    instance_ = new PeriodicFlushManager();
                }
            }
            finally {
                lock_.unlock();
            }
        }
        return instance_;
    }

    public void submitPeriodicFlusher(final ColumnFamilyStore columnFamilyStore, int flushPeriodInMinutes) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                columnFamilyStore.forceFlush();
            }
        };
        this.flusher_.scheduleWithFixedDelay(runnable, flushPeriodInMinutes, flushPeriodInMinutes, TimeUnit.MINUTES);
    }

    static {
        lock_ = new ReentrantLock();
    }
}

